/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import lombok.Generated;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public class ManagedLedgerFactoryConfig {
    private static final long MB = 0x100000L;
    private long maxCacheSize = 0x8000000L;
    private double cacheEvictionWatermark = 0.9;
    private int numManagedLedgerWorkerThreads = Runtime.getRuntime().availableProcessors();
    private int numManagedLedgerSchedulerThreads = Runtime.getRuntime().availableProcessors();
    private long cacheEvictionIntervalMs = 10L;
    private long cacheEvictionTimeThresholdMillis = 1000L;
    private boolean copyEntriesInCache = false;
    private long managedLedgerMaxReadsInFlightSize = 0L;
    private boolean traceTaskExecution = true;
    private int prometheusStatsLatencyRolloverSeconds = 60;
    private int cursorPositionFlushSeconds = 60;
    private int statsPeriodSeconds = 60;
    private String clusterName;
    private String managedLedgerInfoCompressionType = MLDataFormats.CompressionType.NONE.name();
    private String managedCursorInfoCompressionType = MLDataFormats.CompressionType.NONE.name();

    @Generated
    public ManagedLedgerFactoryConfig() {
    }

    @Generated
    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Generated
    public double getCacheEvictionWatermark() {
        return this.cacheEvictionWatermark;
    }

    @Generated
    public int getNumManagedLedgerWorkerThreads() {
        return this.numManagedLedgerWorkerThreads;
    }

    @Generated
    public int getNumManagedLedgerSchedulerThreads() {
        return this.numManagedLedgerSchedulerThreads;
    }

    @Generated
    public long getCacheEvictionIntervalMs() {
        return this.cacheEvictionIntervalMs;
    }

    @Generated
    public long getCacheEvictionTimeThresholdMillis() {
        return this.cacheEvictionTimeThresholdMillis;
    }

    @Generated
    public boolean isCopyEntriesInCache() {
        return this.copyEntriesInCache;
    }

    @Generated
    public long getManagedLedgerMaxReadsInFlightSize() {
        return this.managedLedgerMaxReadsInFlightSize;
    }

    @Generated
    public boolean isTraceTaskExecution() {
        return this.traceTaskExecution;
    }

    @Generated
    public int getPrometheusStatsLatencyRolloverSeconds() {
        return this.prometheusStatsLatencyRolloverSeconds;
    }

    @Generated
    public int getCursorPositionFlushSeconds() {
        return this.cursorPositionFlushSeconds;
    }

    @Generated
    public int getStatsPeriodSeconds() {
        return this.statsPeriodSeconds;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public String getManagedLedgerInfoCompressionType() {
        return this.managedLedgerInfoCompressionType;
    }

    @Generated
    public String getManagedCursorInfoCompressionType() {
        return this.managedCursorInfoCompressionType;
    }

    @Generated
    public void setMaxCacheSize(long maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    @Generated
    public void setCacheEvictionWatermark(double cacheEvictionWatermark) {
        this.cacheEvictionWatermark = cacheEvictionWatermark;
    }

    @Generated
    public void setNumManagedLedgerWorkerThreads(int numManagedLedgerWorkerThreads) {
        this.numManagedLedgerWorkerThreads = numManagedLedgerWorkerThreads;
    }

    @Generated
    public void setNumManagedLedgerSchedulerThreads(int numManagedLedgerSchedulerThreads) {
        this.numManagedLedgerSchedulerThreads = numManagedLedgerSchedulerThreads;
    }

    @Generated
    public void setCacheEvictionIntervalMs(long cacheEvictionIntervalMs) {
        this.cacheEvictionIntervalMs = cacheEvictionIntervalMs;
    }

    @Generated
    public void setCacheEvictionTimeThresholdMillis(long cacheEvictionTimeThresholdMillis) {
        this.cacheEvictionTimeThresholdMillis = cacheEvictionTimeThresholdMillis;
    }

    @Generated
    public void setCopyEntriesInCache(boolean copyEntriesInCache) {
        this.copyEntriesInCache = copyEntriesInCache;
    }

    @Generated
    public void setManagedLedgerMaxReadsInFlightSize(long managedLedgerMaxReadsInFlightSize) {
        this.managedLedgerMaxReadsInFlightSize = managedLedgerMaxReadsInFlightSize;
    }

    @Generated
    public void setTraceTaskExecution(boolean traceTaskExecution) {
        this.traceTaskExecution = traceTaskExecution;
    }

    @Generated
    public void setPrometheusStatsLatencyRolloverSeconds(int prometheusStatsLatencyRolloverSeconds) {
        this.prometheusStatsLatencyRolloverSeconds = prometheusStatsLatencyRolloverSeconds;
    }

    @Generated
    public void setCursorPositionFlushSeconds(int cursorPositionFlushSeconds) {
        this.cursorPositionFlushSeconds = cursorPositionFlushSeconds;
    }

    @Generated
    public void setStatsPeriodSeconds(int statsPeriodSeconds) {
        this.statsPeriodSeconds = statsPeriodSeconds;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Generated
    public void setManagedLedgerInfoCompressionType(String managedLedgerInfoCompressionType) {
        this.managedLedgerInfoCompressionType = managedLedgerInfoCompressionType;
    }

    @Generated
    public void setManagedCursorInfoCompressionType(String managedCursorInfoCompressionType) {
        this.managedCursorInfoCompressionType = managedCursorInfoCompressionType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManagedLedgerFactoryConfig)) {
            return false;
        }
        ManagedLedgerFactoryConfig other = (ManagedLedgerFactoryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxCacheSize() != other.getMaxCacheSize()) {
            return false;
        }
        if (Double.compare(this.getCacheEvictionWatermark(), other.getCacheEvictionWatermark()) != 0) {
            return false;
        }
        if (this.getNumManagedLedgerWorkerThreads() != other.getNumManagedLedgerWorkerThreads()) {
            return false;
        }
        if (this.getNumManagedLedgerSchedulerThreads() != other.getNumManagedLedgerSchedulerThreads()) {
            return false;
        }
        if (this.getCacheEvictionIntervalMs() != other.getCacheEvictionIntervalMs()) {
            return false;
        }
        if (this.getCacheEvictionTimeThresholdMillis() != other.getCacheEvictionTimeThresholdMillis()) {
            return false;
        }
        if (this.isCopyEntriesInCache() != other.isCopyEntriesInCache()) {
            return false;
        }
        if (this.getManagedLedgerMaxReadsInFlightSize() != other.getManagedLedgerMaxReadsInFlightSize()) {
            return false;
        }
        if (this.isTraceTaskExecution() != other.isTraceTaskExecution()) {
            return false;
        }
        if (this.getPrometheusStatsLatencyRolloverSeconds() != other.getPrometheusStatsLatencyRolloverSeconds()) {
            return false;
        }
        if (this.getCursorPositionFlushSeconds() != other.getCursorPositionFlushSeconds()) {
            return false;
        }
        if (this.getStatsPeriodSeconds() != other.getStatsPeriodSeconds()) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        String other$managedLedgerInfoCompressionType = other.getManagedLedgerInfoCompressionType();
        if (this$managedLedgerInfoCompressionType == null ? other$managedLedgerInfoCompressionType != null : !this$managedLedgerInfoCompressionType.equals(other$managedLedgerInfoCompressionType)) {
            return false;
        }
        String this$managedCursorInfoCompressionType = this.getManagedCursorInfoCompressionType();
        String other$managedCursorInfoCompressionType = other.getManagedCursorInfoCompressionType();
        return !(this$managedCursorInfoCompressionType == null ? other$managedCursorInfoCompressionType != null : !this$managedCursorInfoCompressionType.equals(other$managedCursorInfoCompressionType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManagedLedgerFactoryConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxCacheSize = this.getMaxCacheSize();
        result = result * 59 + (int)($maxCacheSize >>> 32 ^ $maxCacheSize);
        long $cacheEvictionWatermark = Double.doubleToLongBits(this.getCacheEvictionWatermark());
        result = result * 59 + (int)($cacheEvictionWatermark >>> 32 ^ $cacheEvictionWatermark);
        result = result * 59 + this.getNumManagedLedgerWorkerThreads();
        result = result * 59 + this.getNumManagedLedgerSchedulerThreads();
        long $cacheEvictionIntervalMs = this.getCacheEvictionIntervalMs();
        result = result * 59 + (int)($cacheEvictionIntervalMs >>> 32 ^ $cacheEvictionIntervalMs);
        long $cacheEvictionTimeThresholdMillis = this.getCacheEvictionTimeThresholdMillis();
        result = result * 59 + (int)($cacheEvictionTimeThresholdMillis >>> 32 ^ $cacheEvictionTimeThresholdMillis);
        result = result * 59 + (this.isCopyEntriesInCache() ? 79 : 97);
        long $managedLedgerMaxReadsInFlightSize = this.getManagedLedgerMaxReadsInFlightSize();
        result = result * 59 + (int)($managedLedgerMaxReadsInFlightSize >>> 32 ^ $managedLedgerMaxReadsInFlightSize);
        result = result * 59 + (this.isTraceTaskExecution() ? 79 : 97);
        result = result * 59 + this.getPrometheusStatsLatencyRolloverSeconds();
        result = result * 59 + this.getCursorPositionFlushSeconds();
        result = result * 59 + this.getStatsPeriodSeconds();
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $managedLedgerInfoCompressionType = this.getManagedLedgerInfoCompressionType();
        result = result * 59 + ($managedLedgerInfoCompressionType == null ? 43 : $managedLedgerInfoCompressionType.hashCode());
        String $managedCursorInfoCompressionType = this.getManagedCursorInfoCompressionType();
        result = result * 59 + ($managedCursorInfoCompressionType == null ? 43 : $managedCursorInfoCompressionType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ManagedLedgerFactoryConfig(maxCacheSize=" + this.getMaxCacheSize() + ", cacheEvictionWatermark=" + this.getCacheEvictionWatermark() + ", numManagedLedgerWorkerThreads=" + this.getNumManagedLedgerWorkerThreads() + ", numManagedLedgerSchedulerThreads=" + this.getNumManagedLedgerSchedulerThreads() + ", cacheEvictionIntervalMs=" + this.getCacheEvictionIntervalMs() + ", cacheEvictionTimeThresholdMillis=" + this.getCacheEvictionTimeThresholdMillis() + ", copyEntriesInCache=" + this.isCopyEntriesInCache() + ", managedLedgerMaxReadsInFlightSize=" + this.getManagedLedgerMaxReadsInFlightSize() + ", traceTaskExecution=" + this.isTraceTaskExecution() + ", prometheusStatsLatencyRolloverSeconds=" + this.getPrometheusStatsLatencyRolloverSeconds() + ", cursorPositionFlushSeconds=" + this.getCursorPositionFlushSeconds() + ", statsPeriodSeconds=" + this.getStatsPeriodSeconds() + ", clusterName=" + this.getClusterName() + ", managedLedgerInfoCompressionType=" + this.getManagedLedgerInfoCompressionType() + ", managedCursorInfoCompressionType=" + this.getManagedCursorInfoCompressionType() + ")";
    }
}

