/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.io.AbstractByteBufferPool;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.io.ByteBufferPool;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.util.BufferUtil;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.util.annotation.ManagedObject;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.util.component.Dumpable;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.util.component.DumpableCollection;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.util.log.Log;
import org.apache.pulsar.v3_0_8.shade.org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class MappedByteBufferPool
extends AbstractByteBufferPool
implements Dumpable {
    private static final Logger LOG = Log.getLogger(MappedByteBufferPool.class);
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _directBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _heapBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final Function<Integer, ByteBufferPool.Bucket> _newBucket;
    private boolean _detailedDump = false;

    public MappedByteBufferPool() {
        this(-1);
    }

    public MappedByteBufferPool(int factor) {
        this(factor, -1);
    }

    public MappedByteBufferPool(int factor, int maxQueueLength) {
        this(factor, maxQueueLength, null);
    }

    public MappedByteBufferPool(int factor, int maxQueueLength, Function<Integer, ByteBufferPool.Bucket> newBucket) {
        this(factor, maxQueueLength, newBucket, 0L, 0L);
    }

    public MappedByteBufferPool(int factor, int maxQueueLength, Function<Integer, ByteBufferPool.Bucket> newBucket, long maxHeapMemory, long maxDirectMemory) {
        super(factor, maxQueueLength, maxHeapMemory, maxDirectMemory);
        this._newBucket = newBucket;
    }

    private ByteBufferPool.Bucket newBucket(int key, boolean direct) {
        return this._newBucket != null ? this._newBucket.apply(key) : new ByteBufferPool.Bucket(this, this.capacityFor(key), this.getMaxQueueLength(), this.updateMemory(direct));
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        int b = this.bucketFor(size);
        int capacity = this.capacityFor(b);
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buffers = this.bucketsFor(direct);
        ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)buffers.get(b);
        if (bucket == null) {
            return this.newByteBuffer(capacity, direct);
        }
        ByteBuffer buffer = bucket.acquire();
        if (buffer == null) {
            return this.newByteBuffer(capacity, direct);
        }
        return buffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        int b;
        if (buffer == null) {
            return;
        }
        int capacity = buffer.capacity();
        if (capacity != this.capacityFor(b = this.bucketFor(capacity))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", BufferUtil.toDetailString(buffer));
            }
            return;
        }
        boolean direct = buffer.isDirect();
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buckets = this.bucketsFor(direct);
        ByteBufferPool.Bucket bucket = buckets.computeIfAbsent(b, i -> this.newBucket((int)i, direct));
        bucket.release(buffer);
        this.releaseExcessMemory(direct, this::releaseMemory);
    }

    @Override
    public void clear() {
        super.clear();
        this._directBuffers.values().forEach(ByteBufferPool.Bucket::clear);
        this._directBuffers.clear();
        this._heapBuffers.values().forEach(ByteBufferPool.Bucket::clear);
        this._heapBuffers.clear();
    }

    protected void releaseMemory(boolean direct) {
        ByteBufferPool.Bucket bucket;
        long oldest = Long.MAX_VALUE;
        int index = -1;
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buckets = this.bucketsFor(direct);
        for (Map.Entry entry : buckets.entrySet()) {
            long lastUpdate;
            ByteBufferPool.Bucket bucket2 = (ByteBufferPool.Bucket)entry.getValue();
            if (bucket2.isEmpty() || (lastUpdate = bucket2.getLastUpdate()) >= oldest) continue;
            oldest = lastUpdate;
            index = (Integer)entry.getKey();
        }
        if (index >= 0 && (bucket = (ByteBufferPool.Bucket)buckets.remove(index)) != null) {
            bucket.clear();
        }
    }

    protected int bucketFor(int capacity) {
        return (int)Math.ceil((double)capacity / (double)this.getCapacityFactor());
    }

    protected int capacityFor(int bucket) {
        return bucket * this.getCapacityFactor();
    }

    @ManagedAttribute(value="The number of pooled direct ByteBuffers")
    public long getDirectByteBufferCount() {
        return this.getByteBufferCount(true);
    }

    @ManagedAttribute(value="The number of pooled heap ByteBuffers")
    public long getHeapByteBufferCount() {
        return this.getByteBufferCount(false);
    }

    private long getByteBufferCount(boolean direct) {
        return this.bucketsFor(direct).values().stream().mapToLong(ByteBufferPool.Bucket::size).sum();
    }

    ConcurrentMap<Integer, ByteBufferPool.Bucket> bucketsFor(boolean direct) {
        return direct ? this._directBuffers : this._heapBuffers;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Object> dump = new ArrayList<Object>();
        dump.add(String.format("HeapMemory: %d/%d", this.getHeapMemory(), this.getMaxHeapMemory()));
        dump.add(String.format("DirectMemory: %d/%d", this.getDirectMemory(), this.getMaxDirectMemory()));
        if (this.isDetailedDump()) {
            dump.add(new DumpableCollection("Indirect Buckets", this._heapBuffers.values()));
            dump.add(new DumpableCollection("Direct Buckets", this._directBuffers.values()));
        } else {
            dump.add("Indirect Buckets size=" + this._heapBuffers.size());
            dump.add("Direct Buckets size=" + this._directBuffers.size());
        }
        Dumpable.dumpObjects(out, indent, this, dump);
    }

    public String toString() {
        return String.format("%s@%x{maxQueueLength=%s, factor=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getMaxQueueLength(), this.getCapacityFactor());
    }

    public static class Tagged
    extends MappedByteBufferPool {
        private final AtomicInteger tag = new AtomicInteger();

        @Override
        public ByteBuffer newByteBuffer(int capacity, boolean direct) {
            ByteBuffer buffer = super.newByteBuffer(capacity + 4, direct);
            buffer.limit(buffer.capacity());
            buffer.putInt(this.tag.incrementAndGet());
            ByteBuffer slice = buffer.slice();
            BufferUtil.clear(slice);
            return slice;
        }
    }
}

