/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import io.airlift.log.Logger;
import io.netty.buffer.ByteBuf;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableLayoutHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.sql.presto.PulsarConnectorCache;
import org.apache.pulsar.sql.presto.PulsarConnectorConfig;
import org.apache.pulsar.sql.presto.PulsarConnectorId;
import org.apache.pulsar.sql.presto.PulsarConnectorUtils;
import org.apache.pulsar.sql.presto.PulsarInternalColumn;
import org.apache.pulsar.sql.presto.PulsarSplit;
import org.apache.pulsar.sql.presto.PulsarSqlSchemaInfoProvider;
import org.apache.pulsar.sql.presto.PulsarTableHandle;
import org.apache.pulsar.sql.presto.PulsarTableLayoutHandle;

public class PulsarSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final PulsarConnectorConfig pulsarConnectorConfig;
    private final PulsarAdmin pulsarAdmin;
    private static final Logger log = Logger.get(PulsarSplitManager.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public PulsarSplitManager(PulsarConnectorId connectorId, PulsarConnectorConfig pulsarConnectorConfig) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.pulsarConnectorConfig = Objects.requireNonNull(pulsarConnectorConfig, "pulsarConnectorConfig is null");
        try {
            this.pulsarAdmin = pulsarConnectorConfig.getPulsarAdmin();
        }
        catch (PulsarClientException e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        Collection<PulsarSplit> splits;
        SchemaInfo schemaInfo;
        int numSplits = this.pulsarConnectorConfig.getTargetNumSplits();
        PulsarTableLayoutHandle layoutHandle = (PulsarTableLayoutHandle)layout;
        PulsarTableHandle tableHandle = layoutHandle.getTable();
        TupleDomain<ColumnHandle> tupleDomain = layoutHandle.getTupleDomain();
        String namespace = PulsarConnectorUtils.restoreNamespaceDelimiterIfNeeded(tableHandle.getSchemaName(), this.pulsarConnectorConfig);
        TopicName topicName = TopicName.get((String)"persistent", (NamespaceName)NamespaceName.get((String)namespace), (String)tableHandle.getTopicName());
        try {
            schemaInfo = this.pulsarAdmin.schemas().getSchemaInfo(String.format("%s/%s", namespace, tableHandle.getTopicName()));
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 401) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get pulsar topic schema for topic %s/%s: Unauthorized", namespace, tableHandle.getTopicName()));
            }
            if (e.getStatusCode() == 404) {
                schemaInfo = PulsarSqlSchemaInfoProvider.defaultSchema();
            }
            throw new RuntimeException("Failed to get pulsar topic schema for topic " + String.format("%s/%s", namespace, tableHandle.getTopicName()) + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        try {
            OffloadPoliciesImpl offloadPolicies = (OffloadPoliciesImpl)this.pulsarAdmin.namespaces().getOffloadPolicies(topicName.getNamespace());
            if (offloadPolicies != null) {
                offloadPolicies.setOffloadersDirectory(this.pulsarConnectorConfig.getOffloadersDirectory());
                offloadPolicies.setManagedLedgerOffloadMaxThreads(Integer.valueOf(this.pulsarConnectorConfig.getManagedLedgerOffloadMaxThreads()));
            }
            if (!PulsarConnectorUtils.isPartitionedTopic(topicName, this.pulsarAdmin)) {
                splits = this.getSplitsNonPartitionedTopic(numSplits, topicName, tableHandle, schemaInfo, tupleDomain, offloadPolicies);
                log.debug("Splits for non-partitioned topic %s: %s", new Object[]{topicName, splits});
            } else {
                splits = this.getSplitsPartitionedTopic(numSplits, topicName, tableHandle, schemaInfo, tupleDomain, offloadPolicies);
                log.debug("Splits for partitioned topic %s: %s", new Object[]{topicName, splits});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to get splits");
            throw new RuntimeException(e);
        }
        return new FixedSplitSource(splits);
    }

    @VisibleForTesting
    Collection<PulsarSplit> getSplitsPartitionedTopic(int numSplits, TopicName topicName, PulsarTableHandle tableHandle, SchemaInfo schemaInfo, TupleDomain<ColumnHandle> tupleDomain, OffloadPoliciesImpl offloadPolicies) throws Exception {
        List<Integer> predicatedPartitions = this.getPredicatedPartitions(topicName, tupleDomain);
        if (log.isDebugEnabled()) {
            log.debug("Partition filter result %s", new Object[]{predicatedPartitions});
        }
        int actualNumSplits = Math.max(predicatedPartitions.size(), numSplits);
        int splitsPerPartition = actualNumSplits / predicatedPartitions.size();
        int splitRemainder = actualNumSplits % predicatedPartitions.size();
        PulsarConnectorCache pulsarConnectorCache = PulsarConnectorCache.getConnectorCache(this.pulsarConnectorConfig);
        ManagedLedgerFactory managedLedgerFactory = pulsarConnectorCache.getManagedLedgerFactory();
        ManagedLedgerConfig managedLedgerConfig = pulsarConnectorCache.getManagedLedgerConfig(topicName.getNamespaceObject(), offloadPolicies, this.pulsarConnectorConfig);
        LinkedList<PulsarSplit> splits = new LinkedList<PulsarSplit>();
        for (int i = 0; i < predicatedPartitions.size(); ++i) {
            int splitsForThisPartition = splitRemainder > i ? splitsPerPartition + 1 : splitsPerPartition;
            splits.addAll(this.getSplitsForTopic(topicName.getPartition(predicatedPartitions.get(i).intValue()).getPersistenceNamingEncoding(), managedLedgerFactory, managedLedgerConfig, splitsForThisPartition, tableHandle, schemaInfo, topicName.getPartition(predicatedPartitions.get(i).intValue()).getLocalName(), tupleDomain, offloadPolicies));
        }
        return splits;
    }

    private List<Integer> getPredicatedPartitions(TopicName topicName, TupleDomain<ColumnHandle> tupleDomain) {
        int numPartitions;
        try {
            numPartitions = this.pulsarAdmin.topics().getPartitionedTopicMetadata((String)topicName.toString()).partitions;
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 401) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Failed to get metadata for partitioned topic %s: Unauthorized", topicName));
            }
            throw new RuntimeException("Failed to get metadata for partitioned topic " + topicName + ": " + ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e);
        }
        ArrayList<Integer> predicatePartitions = new ArrayList<Integer>();
        if (tupleDomain.getDomains().isPresent()) {
            Domain domain = (Domain)((Map)tupleDomain.getDomains().get()).get(PulsarInternalColumn.PARTITION.getColumnHandle(this.connectorId, false));
            if (domain != null) {
                domain.getValues().getValuesProcessor().consume(ranges -> domain.getValues().getRanges().getOrderedRanges().forEach(range -> {
                    Block block;
                    int low = 0;
                    int high = numPartitions;
                    if (range.getLowValue().isPresent()) {
                        block = Utils.nativeValueToBlock((Type)range.getType(), (Object)range.getLowBoundedValue());
                        low = block.getInt(0, 0);
                    }
                    if (range.getHighValue().isPresent()) {
                        block = Utils.nativeValueToBlock((Type)range.getType(), (Object)range.getHighBoundedValue());
                        high = block.getInt(0, 0);
                    }
                    for (int i = low; i <= high; ++i) {
                        predicatePartitions.add(i);
                    }
                }), discreteValues -> {}, allOrNone -> {});
            } else {
                for (int i = 0; i < numPartitions; ++i) {
                    predicatePartitions.add(i);
                }
            }
        } else {
            for (int i = 0; i < numPartitions; ++i) {
                predicatePartitions.add(i);
            }
        }
        return predicatePartitions;
    }

    @VisibleForTesting
    Collection<PulsarSplit> getSplitsNonPartitionedTopic(int numSplits, TopicName topicName, PulsarTableHandle tableHandle, SchemaInfo schemaInfo, TupleDomain<ColumnHandle> tupleDomain, OffloadPoliciesImpl offloadPolicies) throws Exception {
        PulsarConnectorCache pulsarConnectorCache = PulsarConnectorCache.getConnectorCache(this.pulsarConnectorConfig);
        ManagedLedgerFactory managedLedgerFactory = pulsarConnectorCache.getManagedLedgerFactory();
        ManagedLedgerConfig managedLedgerConfig = pulsarConnectorCache.getManagedLedgerConfig(topicName.getNamespaceObject(), offloadPolicies, this.pulsarConnectorConfig);
        return this.getSplitsForTopic(topicName.getPersistenceNamingEncoding(), managedLedgerFactory, managedLedgerConfig, numSplits, tableHandle, schemaInfo, topicName.getLocalName(), tupleDomain, offloadPolicies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Collection<PulsarSplit> getSplitsForTopic(String topicNamePersistenceEncoding, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig, int numSplits, PulsarTableHandle tableHandle, SchemaInfo schemaInfo, String tableName, TupleDomain<ColumnHandle> tupleDomain, OffloadPoliciesImpl offloadPolicies) throws ManagedLedgerException, InterruptedException, IOException {
        ReadOnlyCursor readOnlyCursor = null;
        try {
            PositionImpl initialStartPosition;
            readOnlyCursor = managedLedgerFactory.openReadOnlyCursor(topicNamePersistenceEncoding, PositionImpl.EARLIEST, managedLedgerConfig);
            long numEntries = readOnlyCursor.getNumberOfEntries();
            if (numEntries <= 0L) {
                List<PulsarSplit> list = Collections.emptyList();
                return list;
            }
            PredicatePushdownInfo predicatePushdownInfo = PredicatePushdownInfo.getPredicatePushdownInfo(this.connectorId, tupleDomain, managedLedgerFactory, managedLedgerConfig, topicNamePersistenceEncoding, numEntries);
            if (predicatePushdownInfo != null) {
                numEntries = predicatePushdownInfo.getNumOfEntries();
                initialStartPosition = predicatePushdownInfo.getStartPosition();
            } else {
                initialStartPosition = (PositionImpl)readOnlyCursor.getReadPosition();
            }
            readOnlyCursor.close();
            readOnlyCursor = managedLedgerFactory.openReadOnlyCursor(topicNamePersistenceEncoding, initialStartPosition, new ManagedLedgerConfig());
            long remainder = numEntries % (long)numSplits;
            long avgEntriesPerSplit = numEntries / (long)numSplits;
            LinkedList<PulsarSplit> splits = new LinkedList<PulsarSplit>();
            for (int i = 0; i < numSplits; ++i) {
                long entriesForSplit = remainder > (long)i ? avgEntriesPerSplit + 1L : avgEntriesPerSplit;
                PositionImpl startPosition = (PositionImpl)readOnlyCursor.getReadPosition();
                readOnlyCursor.skipEntries(Math.toIntExact(entriesForSplit));
                PositionImpl endPosition = (PositionImpl)readOnlyCursor.getReadPosition();
                PulsarSplit pulsarSplit = new PulsarSplit(i, this.connectorId, PulsarConnectorUtils.restoreNamespaceDelimiterIfNeeded(tableHandle.getSchemaName(), this.pulsarConnectorConfig), schemaInfo.getName(), tableName, entriesForSplit, new String(schemaInfo.getSchema(), "ISO8859-1"), schemaInfo.getType(), startPosition.getEntryId(), endPosition.getEntryId(), startPosition.getLedgerId(), endPosition.getLedgerId(), tupleDomain, this.objectMapper.writeValueAsString((Object)schemaInfo.getProperties()), offloadPolicies);
                splits.add(pulsarSplit);
            }
            LinkedList<PulsarSplit> linkedList = splits;
            return linkedList;
        }
        finally {
            if (readOnlyCursor != null) {
                try {
                    readOnlyCursor.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    private static PositionImpl findPosition(ReadOnlyCursor readOnlyCursor, long timestamp) throws ManagedLedgerException, InterruptedException {
        return (PositionImpl)readOnlyCursor.findNewestMatching(ManagedCursor.FindPositionConstraint.SearchAllAvailableEntries, entry -> {
            try {
                long entryTimestamp = Commands.getEntryTimestamp((ByteBuf)entry.getDataBuffer());
                boolean bl = entryTimestamp <= timestamp;
                return bl;
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed To deserialize message when finding position with error: %s", new Object[]{e});
            }
            finally {
                entry.release();
            }
            return false;
        });
    }

    private static class PredicatePushdownInfo {
        private PositionImpl startPosition;
        private PositionImpl endPosition;
        private long numOfEntries;

        private PredicatePushdownInfo(PositionImpl startPosition, PositionImpl endPosition, long numOfEntries) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.numOfEntries = numOfEntries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PredicatePushdownInfo getPredicatePushdownInfo(String connectorId, TupleDomain<ColumnHandle> tupleDomain, ManagedLedgerFactory managedLedgerFactory, ManagedLedgerConfig managedLedgerConfig, String topicNamePersistenceEncoding, long totalNumEntries) throws ManagedLedgerException, InterruptedException {
            try (ReadOnlyCursor readOnlyCursor = null;){
                Domain domain;
                readOnlyCursor = managedLedgerFactory.openReadOnlyCursor(topicNamePersistenceEncoding, PositionImpl.EARLIEST, managedLedgerConfig);
                if (tupleDomain.getDomains().isPresent() && (domain = (Domain)((Map)tupleDomain.getDomains().get()).get(PulsarInternalColumn.PUBLISH_TIME.getColumnHandle(connectorId, false))) != null && domain.getValues().getRanges().getRangeCount() == 1) {
                    PositionImpl overallEndPos;
                    PositionImpl overallStartPos;
                    Block block;
                    Preconditions.checkArgument((boolean)domain.getType().isOrderable(), (Object)"Domain type must be orderable");
                    Long upperBoundTs = null;
                    Long lowerBoundTs = null;
                    Range range = (Range)domain.getValues().getRanges().getOrderedRanges().get(0);
                    if (!range.isHighUnbounded()) {
                        block = Utils.nativeValueToBlock((Type)range.getType(), (Object)range.getHighBoundedValue());
                        upperBoundTs = block.getLong(0, 0) / 1000L;
                    }
                    if (!range.isLowUnbounded()) {
                        block = Utils.nativeValueToBlock((Type)range.getType(), (Object)range.getLowBoundedValue());
                        lowerBoundTs = block.getLong(0, 0) / 1000L;
                    }
                    if (lowerBoundTs == null) {
                        overallStartPos = (PositionImpl)readOnlyCursor.getReadPosition();
                    } else {
                        overallStartPos = PulsarSplitManager.findPosition(readOnlyCursor, lowerBoundTs);
                        if (overallStartPos == null) {
                            overallStartPos = (PositionImpl)readOnlyCursor.getReadPosition();
                        }
                    }
                    if (upperBoundTs == null) {
                        readOnlyCursor.skipEntries(Math.toIntExact(totalNumEntries));
                        overallEndPos = (PositionImpl)readOnlyCursor.getReadPosition();
                    } else {
                        overallEndPos = PulsarSplitManager.findPosition(readOnlyCursor, upperBoundTs);
                        if (overallEndPos == null) {
                            overallEndPos = overallStartPos;
                        }
                    }
                    com.google.common.collect.Range posRange = com.google.common.collect.Range.range((Comparable)overallStartPos, (BoundType)BoundType.CLOSED, (Comparable)overallEndPos, (BoundType)BoundType.CLOSED);
                    long numOfEntries = readOnlyCursor.getNumberOfEntries((com.google.common.collect.Range<PositionImpl>)posRange) - 1L;
                    PredicatePushdownInfo predicatePushdownInfo = new PredicatePushdownInfo(overallStartPos, overallEndPos, numOfEntries);
                    log.debug("Predicate pushdown optimization calculated: %s", new Object[]{predicatePushdownInfo});
                    PredicatePushdownInfo predicatePushdownInfo2 = predicatePushdownInfo;
                    return predicatePushdownInfo2;
                }
            }
            return null;
        }

        @Generated
        public PositionImpl getStartPosition() {
            return this.startPosition;
        }

        @Generated
        public PositionImpl getEndPosition() {
            return this.endPosition;
        }

        @Generated
        public long getNumOfEntries() {
            return this.numOfEntries;
        }

        @Generated
        public void setStartPosition(PositionImpl startPosition) {
            this.startPosition = startPosition;
        }

        @Generated
        public void setEndPosition(PositionImpl endPosition) {
            this.endPosition = endPosition;
        }

        @Generated
        public void setNumOfEntries(long numOfEntries) {
            this.numOfEntries = numOfEntries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PredicatePushdownInfo)) {
                return false;
            }
            PredicatePushdownInfo other = (PredicatePushdownInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNumOfEntries() != other.getNumOfEntries()) {
                return false;
            }
            PositionImpl this$startPosition = this.getStartPosition();
            PositionImpl other$startPosition = other.getStartPosition();
            if (this$startPosition == null ? other$startPosition != null : !((Object)this$startPosition).equals(other$startPosition)) {
                return false;
            }
            PositionImpl this$endPosition = this.getEndPosition();
            PositionImpl other$endPosition = other.getEndPosition();
            return !(this$endPosition == null ? other$endPosition != null : !((Object)this$endPosition).equals(other$endPosition));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PredicatePushdownInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $numOfEntries = this.getNumOfEntries();
            result = result * 59 + (int)($numOfEntries >>> 32 ^ $numOfEntries);
            PositionImpl $startPosition = this.getStartPosition();
            result = result * 59 + ($startPosition == null ? 43 : ((Object)$startPosition).hashCode());
            PositionImpl $endPosition = this.getEndPosition();
            result = result * 59 + ($endPosition == null ? 43 : ((Object)$endPosition).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PulsarSplitManager.PredicatePushdownInfo(startPosition=" + this.getStartPosition() + ", endPosition=" + this.getEndPosition() + ", numOfEntries=" + this.getNumOfEntries() + ")";
        }
    }
}

