/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Worker;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.v3_0_8.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.v3_0_8.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.v3_0_8.shade.javax.ws.rs.core.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl
extends BaseResource
implements Worker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final WebTarget workerStats;
    private final WebTarget worker;

    public WorkerImpl(WebTarget web, Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.worker = web.path("/admin/v2/worker");
        this.workerStats = web.path("/admin/v2/worker-stats");
    }

    public List<WorkerFunctionInstanceStats> getFunctionsStats() throws PulsarAdminException {
        return (List)this.sync(() -> this.getFunctionsStatsAsync());
    }

    public CompletableFuture<List<WorkerFunctionInstanceStats>> getFunctionsStatsAsync() {
        WebTarget path = this.workerStats.path("functionsmetrics");
        return this.asyncGetRequest(path, new GenericType<List<WorkerFunctionInstanceStats>>(){});
    }

    public Collection<Metrics> getMetrics() throws PulsarAdminException {
        return (Collection)this.sync(() -> this.getMetricsAsync());
    }

    public CompletableFuture<Collection<Metrics>> getMetricsAsync() {
        WebTarget path = this.workerStats.path("metrics");
        return this.asyncGetRequest(path, new GenericType<List<Metrics>>(){}).thenApply(list -> list);
    }

    public List<WorkerInfo> getCluster() throws PulsarAdminException {
        return (List)this.sync(() -> this.getClusterAsync());
    }

    public CompletableFuture<List<WorkerInfo>> getClusterAsync() {
        WebTarget path = this.worker.path("cluster");
        return this.asyncGetRequest(path, new GenericType<List<WorkerInfo>>(){});
    }

    public WorkerInfo getClusterLeader() throws PulsarAdminException {
        return (WorkerInfo)this.sync(() -> this.getClusterLeaderAsync());
    }

    public CompletableFuture<WorkerInfo> getClusterLeaderAsync() {
        WebTarget path = this.worker.path("cluster").path("leader");
        return this.asyncGetRequest(path, new GenericType<WorkerInfo>(){});
    }

    public Map<String, Collection<String>> getAssignments() throws PulsarAdminException {
        return (Map)this.sync(() -> this.getAssignmentsAsync());
    }

    public CompletableFuture<Map<String, Collection<String>>> getAssignmentsAsync() {
        WebTarget path = this.worker.path("assignments");
        return this.asyncGetRequest(path, new GenericType<Map<String, Collection<String>>>(){});
    }

    public void rebalance() throws PulsarAdminException {
        this.sync(this::rebalanceAsync);
    }

    public CompletableFuture<Void> rebalanceAsync() {
        WebTarget path = this.worker.path("rebalance");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }
}

