/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.v3_0_8.shade.javax.ws.rs.client.WebTarget;
import org.asynchttpclient.RequestBuilder;

public class ComponentResource
extends BaseResource {
    protected ComponentResource(Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
    }

    public RequestBuilder addAuthHeaders(WebTarget target, RequestBuilder requestBuilder) throws PulsarAdminException {
        try {
            Set<Map.Entry<String, String>> headers;
            if (this.auth != null && (headers = this.getAuthHeaders(target)) != null && !headers.isEmpty()) {
                headers.forEach(header -> requestBuilder.addHeader((CharSequence)header.getKey(), (String)header.getValue()));
            }
            return requestBuilder;
        }
        catch (Throwable t) {
            throw new PulsarAdminException.GettingAuthenticationDataException(t);
        }
    }

    private Set<Map.Entry<String, String>> getAuthHeaders(WebTarget target) throws Exception {
        AuthenticationDataProvider authData = this.auth.getAuthData(target.getUri().getHost());
        String targetUrl = target.getUri().toString();
        if (this.auth.getAuthMethodName().equalsIgnoreCase("sasl")) {
            CompletableFuture authFuture = new CompletableFuture();
            this.auth.authenticationStage(targetUrl, authData, null, authFuture);
            return this.auth.newRequestHeader(targetUrl, authData, (Map)authFuture.get());
        }
        if (authData.hasDataForHttp()) {
            return this.auth.newRequestHeader(targetUrl, authData, null);
        }
        return null;
    }

    protected ObjectWriter objectWriter() {
        return ObjectMapperFactory.getMapper().writer();
    }

    protected ObjectReader objectReader() {
        return ObjectMapperFactory.getMapper().reader();
    }
}

