/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.Bookies;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.common.policies.data.BookiesClusterInfo;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.v3_0_8.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.v3_0_8.shade.javax.ws.rs.client.WebTarget;

public class BookiesImpl
extends BaseResource
implements Bookies {
    private final WebTarget adminBookies;

    public BookiesImpl(WebTarget web, Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.adminBookies = web.path("/admin/v2/bookies");
    }

    public BookiesRackConfiguration getBookiesRackInfo() throws PulsarAdminException {
        return (BookiesRackConfiguration)this.sync(this::getBookiesRackInfoAsync);
    }

    public CompletableFuture<BookiesClusterInfo> getBookiesAsync() {
        WebTarget path = this.adminBookies.path("all");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BookiesClusterInfo>(){});
    }

    public BookiesClusterInfo getBookies() throws PulsarAdminException {
        return (BookiesClusterInfo)this.sync(this::getBookiesAsync);
    }

    public CompletableFuture<BookiesRackConfiguration> getBookiesRackInfoAsync() {
        WebTarget path = this.adminBookies.path("racks-info");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BookiesRackConfiguration>(){});
    }

    public BookieInfo getBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        return (BookieInfo)this.sync(() -> this.getBookieRackInfoAsync(bookieAddress));
    }

    public CompletableFuture<BookieInfo> getBookieRackInfoAsync(String bookieAddress) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BookieInfo>(){});
    }

    public void deleteBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        this.sync(() -> this.deleteBookieRackInfoAsync(bookieAddress));
    }

    public CompletableFuture<Void> deleteBookieRackInfoAsync(String bookieAddress) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress);
        return this.asyncDeleteRequest(path);
    }

    public void updateBookieRackInfo(String bookieAddress, String group, BookieInfo bookieInfo) throws PulsarAdminException {
        this.sync(() -> this.updateBookieRackInfoAsync(bookieAddress, group, bookieInfo));
    }

    public CompletableFuture<Void> updateBookieRackInfoAsync(String bookieAddress, String group, BookieInfo bookieInfo) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress).queryParam("group", group);
        return this.asyncPostRequest(path, Entity.entity(bookieInfo, "application/json"));
    }
}

