/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Row
extends Expression {
    private final List<Expression> items;

    public Row(List<Expression> items) {
        this(Optional.empty(), items);
    }

    public Row(NodeLocation location, List<Expression> items) {
        this(Optional.of(location), items);
    }

    private Row(Optional<NodeLocation> location, List<Expression> items) {
        super(location);
        Objects.requireNonNull(items, "items is null");
        this.items = ImmutableList.copyOf(items);
    }

    public List<Expression> getItems() {
        return this.items;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRow(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.items;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.items);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return Objects.equals(this.items, other.items);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Row.sameClass(this, other);
    }
}

