/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class ImpersonationRule {
    private final Optional<Pattern> originalUserPattern;
    private final Optional<Pattern> originalRolePattern;
    private final Pattern newUserPattern;
    private final boolean allow;

    @JsonCreator
    public ImpersonationRule(@JsonProperty(value="original_user") @JsonAlias(value={"originalUser"}) Optional<Pattern> originalUserPattern, @JsonProperty(value="original_role") Optional<Pattern> originalRolePattern, @JsonProperty(value="new_user") @JsonAlias(value={"newUser"}) Pattern newUserPattern, @JsonProperty(value="allow") Boolean allow) {
        this.originalUserPattern = Objects.requireNonNull(originalUserPattern, "originalUserPattern is null");
        this.originalRolePattern = Objects.requireNonNull(originalRolePattern, "originalRolePattern is null");
        this.newUserPattern = Objects.requireNonNull(newUserPattern, "newUserPattern is null");
        this.allow = (Boolean)MoreObjects.firstNonNull((Object)allow, (Object)Boolean.TRUE);
    }

    public Optional<Boolean> match(String originalUser, Set<String> originalRoles, String newUser) {
        if (this.originalUserPattern.map(regex -> regex.matcher(originalUser).matches()).orElse(true).booleanValue() && this.originalRolePattern.map(regex -> originalRoles.stream().anyMatch(role -> regex.matcher((CharSequence)role).matches())).orElse(true).booleanValue() && this.newUserPattern.matcher(newUser).matches()) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }
}

