/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import lombok.Generated;

public interface LongPairRangeSet<T extends Comparable<T>> {
    public void addOpenClosed(long var1, long var3, long var5, long var7);

    public boolean contains(long var1, long var3);

    public Range<T> rangeContaining(long var1, long var3);

    public void removeAtMost(long var1, long var3);

    public boolean isEmpty();

    public void clear();

    public Range<T> span();

    public Collection<Range<T>> asRanges();

    public void forEach(RangeProcessor<T> var1);

    public void forEach(RangeProcessor<T> var1, LongPairConsumer<? extends T> var2);

    public void forEachRawRange(RawRangeProcessor var1);

    public int size();

    public Range<T> firstRange();

    public Range<T> lastRange();

    public int cardinality(long var1, long var3, long var5, long var7);

    public static class DefaultRangeSet<T extends Comparable<T>>
    implements LongPairRangeSet<T> {
        RangeSet<T> set = TreeRangeSet.create();
        private final LongPairConsumer<T> consumer;
        private final RangeBoundConsumer<T> rangeEndPointConsumer;

        public DefaultRangeSet(LongPairConsumer<T> consumer, RangeBoundConsumer<T> reverseConsumer) {
            this.consumer = consumer;
            this.rangeEndPointConsumer = reverseConsumer;
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public void addOpenClosed(long key1, long value1, long key2, long value2) {
            this.set.add(Range.openClosed((Comparable)((Comparable)this.consumer.apply(key1, value1)), (Comparable)((Comparable)this.consumer.apply(key2, value2))));
        }

        public boolean contains(T position) {
            return this.set.contains(position);
        }

        public Range<T> rangeContaining(T position) {
            return this.set.rangeContaining(position);
        }

        @Override
        public Range<T> rangeContaining(long key, long value) {
            return this.rangeContaining((Comparable)this.consumer.apply(key, value));
        }

        public void remove(Range<T> range) {
            this.set.remove(range);
        }

        @Override
        public void removeAtMost(long key, long value) {
            this.set.remove(Range.atMost((Comparable)((Comparable)this.consumer.apply(key, value))));
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Range<T> span() {
            try {
                return this.set.span();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        public Set<Range<T>> asRanges() {
            return this.set.asRanges();
        }

        @Override
        public void forEach(RangeProcessor<T> action) {
            this.forEach(action, this.consumer);
        }

        @Override
        public void forEach(RangeProcessor<T> action, LongPairConsumer<? extends T> outerConsumer) {
            Range range;
            Iterator iterator = this.asRanges().iterator();
            while (iterator.hasNext() && action.process(range = (Range)iterator.next())) {
            }
        }

        @Override
        public void forEachRawRange(RawRangeProcessor action) {
            for (Range range : this.asRanges()) {
                LongPair lowerEndpoint = this.rangeEndPointConsumer.apply(range.lowerEndpoint());
                LongPair upperEndpoint = this.rangeEndPointConsumer.apply(range.upperEndpoint());
                if (action.processRawRange(lowerEndpoint.key, lowerEndpoint.value, upperEndpoint.key, upperEndpoint.value)) continue;
                break;
            }
        }

        @Override
        public boolean contains(long key, long value) {
            return this.contains((Comparable)this.consumer.apply(key, value));
        }

        @Override
        public Range<T> firstRange() {
            Iterator iterable = this.set.asRanges().iterator();
            if (iterable.hasNext()) {
                return (Range)iterable.next();
            }
            return null;
        }

        @Override
        public Range<T> lastRange() {
            if (this.set.asRanges().isEmpty()) {
                return null;
            }
            ArrayList list = Lists.newArrayList(this.set.asRanges().iterator());
            return (Range)list.get(list.size() - 1);
        }

        @Override
        public int cardinality(long lowerKey, long lowerValue, long upperKey, long upperValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.set.asRanges().size();
        }

        public String toString() {
            return this.set.toString();
        }
    }

    public static class LongPair
    implements Comparable<LongPair> {
        public static final LongPair earliest = new LongPair(-1L, -1L);
        public static final LongPair latest = new LongPair(Integer.MAX_VALUE, Integer.MAX_VALUE);
        private long key;
        private long value;

        public LongPair(long key, long value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(LongPair that) {
            if (this.key != that.key) {
                return this.key < that.key ? -1 : 1;
            }
            if (this.value != that.value) {
                return this.value < that.value ? -1 : 1;
            }
            return 0;
        }

        public String toString() {
            return this.key + ":" + this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongPair)) {
                return false;
            }
            LongPair other = (LongPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getKey() != other.getKey()) {
                return false;
            }
            return this.getValue() == other.getValue();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LongPair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $key = this.getKey();
            result = result * 59 + (int)($key >>> 32 ^ $key);
            long $value = this.getValue();
            result = result * 59 + (int)($value >>> 32 ^ $value);
            return result;
        }
    }

    public static interface RawRangeProcessor {
        public boolean processRawRange(long var1, long var3, long var5, long var7);
    }

    public static interface RangeProcessor<T extends Comparable<T>> {
        public boolean process(Range<T> var1);
    }

    public static interface RangeBoundConsumer<T> {
        public LongPair apply(T var1);
    }

    public static interface LongPairConsumer<T> {
        public T apply(long var1, long var3);
    }
}

