/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.impl.SnapshotSeekingIterator;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.Slices;

public class SeekingIteratorAdapter
implements DBIterator {
    private final SnapshotSeekingIterator seekingIterator;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public SeekingIteratorAdapter(SnapshotSeekingIterator seekingIterator) {
        this.seekingIterator = seekingIterator;
    }

    public void seekToFirst() {
        this.seekingIterator.seekToFirst();
    }

    public void seek(byte[] targetKey) {
        this.seekingIterator.seek(Slices.wrappedBuffer(targetKey));
    }

    public boolean hasNext() {
        return this.seekingIterator.hasNext();
    }

    public DbEntry next() {
        return this.adapt((Map.Entry<Slice, Slice>)this.seekingIterator.next());
    }

    public DbEntry peekNext() {
        return this.adapt((Map.Entry<Slice, Slice>)this.seekingIterator.peek());
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.seekingIterator.close();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private DbEntry adapt(Map.Entry<Slice, Slice> entry) {
        return new DbEntry(entry.getKey(), entry.getValue());
    }

    public void seekToLast() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPrev() {
        throw new UnsupportedOperationException();
    }

    public DbEntry prev() {
        throw new UnsupportedOperationException();
    }

    public DbEntry peekPrev() {
        throw new UnsupportedOperationException();
    }

    public static class DbEntry
    implements Map.Entry<byte[], byte[]> {
        private final Slice key;
        private final Slice value;

        public DbEntry(Slice key, Slice value) {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(value, "value is null");
            this.key = key;
            this.value = value;
        }

        @Override
        public byte[] getKey() {
            return this.key.getBytes();
        }

        public Slice getKeySlice() {
            return this.key;
        }

        @Override
        public byte[] getValue() {
            return this.value.getBytes();
        }

        public Slice getValueSlice() {
            return this.value;
        }

        @Override
        public byte[] setValue(byte[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

