/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.memory.context.MemoryTrackingContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PageBuffer;
import io.prestosql.operator.ProcessorContext;
import io.prestosql.operator.TopNProcessor;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorOperator;
import io.prestosql.operator.WorkProcessorOperatorAdapter;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TopNOperator
implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator {
    private final TopNProcessor topNProcessor;
    private final WorkProcessor<Page> pages;
    private final PageBuffer pageBuffer = new PageBuffer();

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        return WorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, types, n, sortChannels, sortOrders));
    }

    private TopNOperator(MemoryTrackingContext memoryTrackingContext, Optional<WorkProcessor<Page>> sourcePages, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.topNProcessor = new TopNProcessor(Objects.requireNonNull(memoryTrackingContext, "memoryTrackingContext is null").aggregateUserMemoryContext(), types, n, sortChannels, sortOrders);
        this.pages = n == 0 ? WorkProcessor.of(new Page[0]) : sourcePages.orElse(this.pageBuffer.pages()).transform(new TopNPages());
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public boolean needsInput() {
        return this.pageBuffer.isEmpty() && !this.pageBuffer.isFinished();
    }

    @Override
    public void addInput(Page page) {
        this.addPage(page);
    }

    @Override
    public void finish() {
        this.pageBuffer.finish();
    }

    private void addPage(Page page) {
        this.topNProcessor.addInput(page);
    }

    private class TopNPages
    implements WorkProcessor.Transformation<Page, Page> {
        private TopNPages() {
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            if (inputPage != null) {
                TopNOperator.this.addPage(inputPage);
                return WorkProcessor.TransformationState.needsMoreData();
            }
            Page page = null;
            while (page == null && !TopNOperator.this.topNProcessor.noMoreOutput()) {
                page = TopNOperator.this.topNProcessor.getOutput();
            }
            if (page != null) {
                return WorkProcessor.TransformationState.ofResult(page, false);
            }
            return WorkProcessor.TransformationState.finished();
        }
    }

    private static class Factory
    implements WorkProcessorOperatorAdapter.AdapterWorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final int n;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private boolean closed;

        private Factory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.n = n;
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new TopNOperator(processorContext.getMemoryTrackingContext(), Optional.of(sourcePages), this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }

        @Override
        public WorkProcessorOperatorAdapter.AdapterWorkProcessorOperator createAdapterOperator(ProcessorContext processorContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new TopNOperator(processorContext.getMemoryTrackingContext(), Optional.empty(), this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return TopNOperator.class.getSimpleName();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.sourceTypes, this.n, this.sortChannels, this.sortOrders);
        }
    }
}

