/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.execution.scheduler.NetworkLocation;
import io.prestosql.execution.scheduler.NetworkTopology;
import io.prestosql.execution.scheduler.TopologyFileConfig;
import io.prestosql.spi.HostAddress;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public final class FileBasedNetworkTopology
implements NetworkTopology {
    private static final Logger log = Logger.get(FileBasedNetworkTopology.class);
    private static final Splitter SPLIT_HOST_AND_LOCATION = Splitter.on((CharMatcher)CharMatcher.whitespace()).omitEmptyStrings();
    private static final Splitter SPLIT_SEGMENTS = Splitter.on((char)'/');
    private final File networkTopologyFile;
    private final long refreshPeriodNanos;
    private final Ticker ticker;
    private long lastUpdate;
    @GuardedBy(value="this")
    private Map<String, NetworkLocation> topology;

    @Inject
    public FileBasedNetworkTopology(TopologyFileConfig topologyConfig) {
        this(Objects.requireNonNull(topologyConfig, "topologyConfig is null").getNetworkTopologyFile(), topologyConfig.getRefreshPeriod(), Ticker.systemTicker());
    }

    FileBasedNetworkTopology(File networkTopologyFile, Duration refreshPeriod, Ticker ticker) {
        this.networkTopologyFile = Objects.requireNonNull(networkTopologyFile, "networkTopologyFile is null");
        this.refreshPeriodNanos = Objects.requireNonNull(refreshPeriod, "refreshPeriodNanos is null").roundTo(TimeUnit.NANOSECONDS);
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
        this.refreshTopology();
    }

    @Managed
    public synchronized void refreshTopology() {
        this.lastUpdate = this.ticker.read();
        this.topology = FileBasedNetworkTopology.loadTopologyFile(this.networkTopologyFile);
    }

    private synchronized Map<String, NetworkLocation> getTopology() {
        if (this.ticker.read() - this.lastUpdate >= this.refreshPeriodNanos) {
            try {
                this.refreshTopology();
            }
            catch (RuntimeException e) {
                log.error((Throwable)e);
            }
        }
        return this.topology;
    }

    @Override
    public NetworkLocation locate(HostAddress address) {
        return this.getTopology().getOrDefault(address.getHostText(), NetworkLocation.ROOT_LOCATION);
    }

    private static Map<String, NetworkLocation> loadTopologyFile(File topologyFile) {
        ImmutableList lines;
        ImmutableMap.Builder topology = ImmutableMap.builder();
        try {
            lines = Files.asCharSource((File)topologyFile, (Charset)StandardCharsets.UTF_8).readLines();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not read topology file", e);
        }
        for (int lineNumber = 1; lineNumber <= lines.size(); ++lineNumber) {
            String line = ((String)lines.get(lineNumber - 1)).trim();
            if (line.isEmpty()) continue;
            List parts = SPLIT_HOST_AND_LOCATION.splitToList((CharSequence)line);
            if (parts.size() != 2) {
                throw FileBasedNetworkTopology.invalidFile(lineNumber, "expected two parts for host and location");
            }
            String location = (String)parts.get(1);
            if (!location.startsWith("/")) {
                throw FileBasedNetworkTopology.invalidFile(lineNumber, "location must start with a leading slash");
            }
            List segments = SPLIT_SEGMENTS.splitToList((CharSequence)location.substring(1));
            if (segments.isEmpty()) {
                throw FileBasedNetworkTopology.invalidFile(lineNumber, "location must contain at least one segment");
            }
            if (segments.stream().anyMatch(String::isEmpty)) {
                throw FileBasedNetworkTopology.invalidFile(lineNumber, "location must not contain an empty segment");
            }
            topology.put(parts.get(0), (Object)new NetworkLocation(segments));
        }
        return topology.build();
    }

    private static RuntimeException invalidFile(int lineNumber, String message) {
        return new RuntimeException(String.format("Error in network topology file line %s: %s", lineNumber, message));
    }
}

