/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.coordination.impl;

import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataSerde;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.coordination.ResourceLock;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLockImpl<T>
implements ResourceLock<T> {
    private static final Logger log = LoggerFactory.getLogger(ResourceLockImpl.class);
    private final MetadataStoreExtended store;
    private final MetadataSerde<T> serde;
    private final String path;
    private volatile T value;
    private long version;
    private final CompletableFuture<Void> expiredFuture;
    private boolean revalidateAfterReconnection = false;
    private State state;

    public ResourceLockImpl(MetadataStoreExtended store, MetadataSerde<T> serde, String path, T value) {
        this.store = store;
        this.serde = serde;
        this.path = path;
        this.value = value;
        this.version = -1L;
        this.expiredFuture = new CompletableFuture();
        this.state = State.Init;
    }

    @Override
    public synchronized T getValue() {
        return this.value;
    }

    @Override
    public synchronized CompletableFuture<Void> updateValue(T newValue) {
        byte[] payload;
        try {
            payload = this.serde.serialize(newValue);
        }
        catch (Throwable t) {
            return FutureUtils.exception((Throwable)t);
        }
        return this.store.put(this.path, payload, Optional.of(this.version)).thenAccept(stat -> {
            ResourceLockImpl resourceLockImpl = this;
            synchronized (resourceLockImpl) {
                this.value = newValue;
                this.version = stat.getVersion();
            }
        });
    }

    @Override
    public synchronized CompletableFuture<Void> release() {
        if (this.state == State.Released) {
            return CompletableFuture.completedFuture(null);
        }
        this.state = State.Releasing;
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.store.delete(this.path, Optional.of(this.version)).thenRun(() -> {
            ResourceLockImpl resourceLockImpl = this;
            synchronized (resourceLockImpl) {
                this.state = State.Released;
            }
            this.expiredFuture.complete(null);
            result.complete(null);
        })).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.NotFoundException) {
                ResourceLockImpl resourceLockImpl = this;
                synchronized (resourceLockImpl) {
                    this.state = State.Released;
                }
                this.expiredFuture.complete(null);
                result.complete(null);
            } else {
                result.completeExceptionally((Throwable)ex);
            }
            return null;
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> getLockExpiredFuture() {
        return this.expiredFuture;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    synchronized CompletableFuture<Void> acquire() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.acquireWithNoRevalidation().thenRun(() -> result.complete(null))).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.LockBusyException) {
                ((CompletableFuture)this.revalidate().thenAccept(__ -> result.complete(null))).exceptionally(ex1 -> {
                    result.completeExceptionally((Throwable)ex1);
                    return null;
                });
            } else {
                result.completeExceptionally(ex.getCause());
            }
            return null;
        });
        return result;
    }

    private CompletableFuture<Void> acquireWithNoRevalidation() {
        byte[] payload;
        try {
            payload = this.serde.serialize(this.value);
        }
        catch (Throwable t) {
            return FutureUtils.exception((Throwable)t);
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.store.put(this.path, payload, Optional.of(-1L), EnumSet.of(CreateOption.Ephemeral)).thenAccept(stat -> {
            ResourceLockImpl resourceLockImpl = this;
            synchronized (resourceLockImpl) {
                this.state = State.Valid;
                this.version = stat.getVersion();
            }
            log.info("Acquired resource lock on {}", (Object)this.path);
            result.complete(null);
        })).exceptionally(ex -> {
            if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                result.completeExceptionally(new MetadataStoreException.LockBusyException("Resource at " + this.path + " is already locked"));
            } else {
                result.completeExceptionally(ex.getCause());
            }
            return null;
        });
        return result;
    }

    synchronized void lockWasInvalidated() {
        if (this.state != State.Valid) {
            return;
        }
        log.info("Lock on resource {} was invalidated", (Object)this.path);
        ((CompletableFuture)this.revalidate().thenRun(() -> log.info("Successfully revalidated the lock on {}", (Object)this.path))).exceptionally(ex -> {
            ResourceLockImpl resourceLockImpl = this;
            synchronized (resourceLockImpl) {
                if (ex.getCause() instanceof MetadataStoreException.BadVersionException) {
                    log.warn("Failed to revalidate the lock at {}. Marked as expired", (Object)this.path);
                    this.state = State.Released;
                    this.expiredFuture.complete(null);
                } else {
                    log.warn("Failed to revalidate the lock at {}. Retrying later on reconnection {}", (Object)this.path, (Object)ex.getCause().getMessage());
                }
            }
            return null;
        });
    }

    synchronized void revalidateIfNeededAfterReconnection() {
        if (this.revalidateAfterReconnection) {
            this.revalidateAfterReconnection = false;
            log.warn("Revalidate lock at {} after reconnection", (Object)this.path);
            this.revalidate();
        }
    }

    synchronized CompletableFuture<Void> revalidate() {
        return this.store.get(this.path).thenCompose(optGetResult -> {
            T existingValue;
            if (!optGetResult.isPresent()) {
                return this.acquireWithNoRevalidation().thenRun(() -> log.info("Successfully re-acquired missing lock at {}", (Object)this.path));
            }
            GetResult res = (GetResult)optGetResult.get();
            if (!res.getStat().isEphemeral()) {
                return FutureUtils.exception((Throwable)new MetadataStoreException.LockBusyException("Path " + this.path + " is already created as non-ephemeral"));
            }
            try {
                existingValue = this.serde.deserialize(((GetResult)optGetResult.get()).getValue());
            }
            catch (Throwable t) {
                return FutureUtils.exception((Throwable)t);
            }
            ResourceLockImpl resourceLockImpl = this;
            synchronized (resourceLockImpl) {
                if (this.value.equals(existingValue)) {
                    if (res.getStat().isCreatedBySelf()) {
                        this.version = res.getStat().getVersion();
                    } else {
                        log.info("Deleting stale lock at {}", (Object)this.path);
                        return ((CompletableFuture)this.store.delete(this.path, Optional.of(res.getStat().getVersion())).thenCompose(__ -> this.acquireWithNoRevalidation())).thenRun(() -> log.info("Successfully re-acquired stale lock at {}", (Object)this.path));
                    }
                }
                if (!res.getStat().isCreatedBySelf()) {
                    return FutureUtils.exception((Throwable)new MetadataStoreException.LockBusyException("Resource at " + this.path + " is already locked"));
                }
                return ((CompletableFuture)this.store.delete(this.path, Optional.of(res.getStat().getVersion())).thenCompose(__ -> this.acquireWithNoRevalidation())).thenRun(() -> log.info("Successfully re-acquired lock at {}", (Object)this.path));
            }
        });
    }

    private static enum State {
        Init,
        Valid,
        Releasing,
        Released;

    }
}

