/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.version;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.prestosql.server.ServerConfig;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.util.CompilerUtils;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.inject.Inject;

public class EmbedVersion
implements VersionEmbedder {
    private final MethodHandle runnableConstructor;
    private final MethodHandle callableConstructor;

    @Inject
    public EmbedVersion(ServerConfig serverConfig) {
        Class<?> generatedClass = EmbedVersion.createClass(serverConfig);
        this.runnableConstructor = Reflection.constructorMethodHandle(generatedClass, Runnable.class);
        this.callableConstructor = Reflection.constructorMethodHandle(generatedClass, Callable.class);
    }

    private static Class<?> createClass(ServerConfig serverConfig) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(EmbedVersion.baseClassName(serverConfig)), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(Runnable.class), ParameterizedType.type(Callable.class)});
        EmbedVersion.implementRunnable(classDefinition);
        EmbedVersion.implementCallable(classDefinition);
        return CompilerUtils.defineClass(classDefinition, Runnable.class, (Map<Long, MethodHandle>)ImmutableMap.of(), EmbedVersion.class.getClassLoader());
    }

    private static void implementRunnable(ClassDefinition classDefinition) {
        FieldDefinition field = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "runnable", Runnable.class);
        Parameter parameter = Parameter.arg((String)"runnable", (ParameterizedType)ParameterizedType.type(Runnable.class));
        MethodDefinition constructor = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{parameter});
        constructor.getBody().comment("super();").append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructor.getThis()).append((BytecodeNode)parameter).putField(field).ret();
        MethodDefinition run = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "run", ParameterizedType.type(Void.TYPE), new Parameter[0]);
        run.getBody().comment("runnable.run();").append((BytecodeNode)run.getThis()).getField(field).invokeInterface(Runnable.class, "run", Void.TYPE, new Class[0]).ret();
    }

    private static void implementCallable(ClassDefinition classDefinition) {
        FieldDefinition field = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "callable", Callable.class);
        Parameter parameter = Parameter.arg((String)"callable", (ParameterizedType)ParameterizedType.type(Callable.class));
        MethodDefinition constructor = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{parameter});
        constructor.getBody().comment("super();").append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)constructor.getThis()).append((BytecodeNode)parameter).putField(field).ret();
        MethodDefinition run = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "call", ParameterizedType.type(Object.class), new Parameter[0]);
        run.getBody().comment("callable.call();").append((BytecodeNode)run.getThis()).getField(field).invokeInterface(Callable.class, "call", Object.class, new Class[0]).ret(Object.class);
    }

    private static String baseClassName(ServerConfig serverConfig) {
        String configuredVersion;
        String builtInVersion = new ServerConfig().getPrestoVersion();
        String version = configuredVersion = serverConfig.getPrestoVersion();
        if (!Objects.equals(builtInVersion, configuredVersion)) {
            version = String.format("%s__%s", builtInVersion, configuredVersion);
        }
        return String.format("Presto_%s___", version);
    }

    public Runnable embedVersion(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable is null");
        try {
            return this.runnableConstructor.invoke(runnable);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public <T> Callable<T> embedVersion(Callable<T> callable) {
        Objects.requireNonNull(callable, "callable is null");
        try {
            Callable wrapped = this.callableConstructor.invoke(callable);
            return wrapped;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }
}

