/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.optimizations.ScalarAggregationToJoinRewriter;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.util.MorePredicates;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedScalarAggregationToJoin
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation())).with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));
    private final Metadata metadata;

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    public TransformCorrelatedScalarAggregationToJoin(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = correlatedJoinNode.getSubquery();
        if (!QueryCardinalityUtil.isScalar(subquery, context.getLookup())) {
            return Rule.Result.empty();
        }
        Optional<AggregationNode> aggregation = TransformCorrelatedScalarAggregationToJoin.findAggregation(subquery, context.getLookup());
        if (!aggregation.isPresent() || !aggregation.get().getGroupingKeys().isEmpty()) {
            return Rule.Result.empty();
        }
        ScalarAggregationToJoinRewriter rewriter = new ScalarAggregationToJoinRewriter(this.metadata, context.getSymbolAllocator(), context.getIdAllocator(), context.getLookup());
        PlanNode rewrittenNode = rewriter.rewriteScalarAggregation(correlatedJoinNode, aggregation.get());
        if (rewrittenNode instanceof CorrelatedJoinNode) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewrittenNode);
    }

    private static Optional<AggregationNode> findAggregation(PlanNode rootNode, Lookup lookup) {
        return PlanNodeSearcher.searchFrom(rootNode, lookup).where(AggregationNode.class::isInstance).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class, EnforceSingleRowNode.class)).findFirst();
    }
}

