/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.operator.exchange.LocalExchangeMemoryManager;
import io.prestosql.operator.exchange.LocalExchangeSource;
import io.prestosql.operator.exchange.LocalExchanger;
import io.prestosql.operator.exchange.PageReference;
import io.prestosql.spi.Page;
import java.util.Objects;
import java.util.function.LongConsumer;

public class PassthroughExchanger
implements LocalExchanger {
    private final LocalExchangeSource localExchangeSource;
    private final LocalExchangeMemoryManager bufferMemoryManager;
    private final LongConsumer memoryTracker;

    public PassthroughExchanger(LocalExchangeSource localExchangeSource, long bufferMaxMemory, LongConsumer memoryTracker) {
        this.localExchangeSource = Objects.requireNonNull(localExchangeSource, "localExchangeSource is null");
        this.bufferMemoryManager = new LocalExchangeMemoryManager(bufferMaxMemory);
        this.memoryTracker = Objects.requireNonNull(memoryTracker, "memoryTracker is null");
    }

    @Override
    public void accept(Page page) {
        long retainedSizeInBytes = page.getRetainedSizeInBytes();
        this.bufferMemoryManager.updateMemoryUsage(retainedSizeInBytes);
        this.memoryTracker.accept(retainedSizeInBytes);
        PageReference pageReference = new PageReference(page, 1, () -> {
            this.bufferMemoryManager.updateMemoryUsage(-retainedSizeInBytes);
            this.memoryTracker.accept(-retainedSizeInBytes);
        });
        this.localExchangeSource.addPage(pageReference);
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.bufferMemoryManager.getNotFullFuture();
    }

    @Override
    public void finish() {
        this.localExchangeSource.finish();
    }
}

