/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.aggregation.TypedSet;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DynamicFilterSourceOperator
implements Operator {
    private static final int EXPECTED_BLOCK_BUILDER_SIZE = 8;
    private final OperatorContext context;
    private boolean finished;
    private Page current;
    private final Consumer<TupleDomain<String>> dynamicPredicateConsumer;
    private final int maxFilterPositionsCount;
    private final long maxFilterSizeInBytes;
    private final List<Channel> channels;
    @Nullable
    private BlockBuilder[] blockBuilders;
    @Nullable
    private TypedSet[] valueSets;

    private DynamicFilterSourceOperator(OperatorContext context, Consumer<TupleDomain<String>> dynamicPredicateConsumer, List<Channel> channels, PlanNodeId planNodeId, int maxFilterPositionsCount, DataSize maxFilterSize) {
        this.context = Objects.requireNonNull(context, "context is null");
        this.maxFilterPositionsCount = maxFilterPositionsCount;
        this.maxFilterSizeInBytes = maxFilterSize.toBytes();
        this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.blockBuilders = new BlockBuilder[channels.size()];
        this.valueSets = new TypedSet[channels.size()];
        for (int channelIndex = 0; channelIndex < channels.size(); ++channelIndex) {
            Type type = channels.get(channelIndex).type;
            this.blockBuilders[channelIndex] = type.createBlockBuilder(null, 8);
            this.valueSets[channelIndex] = new TypedSet(type, Optional.empty(), this.blockBuilders[channelIndex], 8, String.format("DynamicFilterSourceOperator_%s_%d", planNodeId, channelIndex), Optional.empty());
        }
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.context;
    }

    @Override
    public boolean needsInput() {
        return this.current == null && !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Verify.verify((!this.finished ? 1 : 0) != 0, (String)"DynamicFilterSourceOperator: addInput() may not be called after finish()", (Object[])new Object[0]);
        this.current = page;
        if (this.valueSets == null) {
            return;
        }
        long filterSizeInBytes = 0L;
        int filterPositionsCount = 0;
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = page.getBlock(this.channels.get(channelIndex).index);
            TypedSet valueSet = this.valueSets[channelIndex];
            for (int position = 0; position < block.getPositionCount(); ++position) {
                valueSet.add(block, position);
            }
            filterSizeInBytes += valueSet.getRetainedSizeInBytes();
            filterPositionsCount += valueSet.size();
        }
        if (filterPositionsCount > this.maxFilterPositionsCount || filterSizeInBytes > this.maxFilterSizeInBytes) {
            this.handleTooLargePredicate();
        }
    }

    private void handleTooLargePredicate() {
        this.dynamicPredicateConsumer.accept((TupleDomain<String>)TupleDomain.all());
        this.valueSets = null;
        this.blockBuilders = null;
    }

    @Override
    public Page getOutput() {
        Page result = this.current;
        this.current = null;
        return result;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.valueSets == null) {
            return;
        }
        ImmutableMap.Builder domainsBuilder = new ImmutableMap.Builder();
        for (int channelIndex = 0; channelIndex < this.channels.size(); ++channelIndex) {
            Block block = this.blockBuilders[channelIndex].build();
            Type type = this.channels.get(channelIndex).type;
            domainsBuilder.put((Object)this.channels.get(channelIndex).filterId, (Object)this.convertToDomain(type, block));
        }
        this.valueSets = null;
        this.blockBuilders = null;
        this.dynamicPredicateConsumer.accept((TupleDomain<String>)TupleDomain.withColumnDomains((Map)domainsBuilder.build()));
    }

    private Domain convertToDomain(Type type, Block block) {
        ImmutableList.Builder values = ImmutableList.builder();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            Object value = TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
            if (value == null) continue;
            values.add(value);
        }
        return Domain.create((ValueSet)ValueSet.copyOf((Type)type, (Collection)values.build()), (boolean)false);
    }

    @Override
    public boolean isFinished() {
        return this.current == null && this.finished;
    }

    public static class DynamicFilterSourceOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Consumer<TupleDomain<String>> dynamicPredicateConsumer;
        private final List<Channel> channels;
        private final int maxFilterPositionsCount;
        private final DataSize maxFilterSize;
        private boolean closed;

        public DynamicFilterSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, Consumer<TupleDomain<String>> dynamicPredicateConsumer, List<Channel> channels, int maxFilterPositionsCount, DataSize maxFilterSize) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.dynamicPredicateConsumer = Objects.requireNonNull(dynamicPredicateConsumer, "dynamicPredicateConsumer is null");
            this.channels = Objects.requireNonNull(channels, "channels is null");
            Verify.verify((channels.stream().map(channel -> ((Channel)channel).filterId).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate dynamic filters are not allowed", (Object[])new Object[0]);
            Verify.verify((channels.stream().map(channel -> ((Channel)channel).index).collect(Collectors.toSet()).size() == channels.size() ? 1 : 0) != 0, (String)"duplicate channel indices are not allowed", (Object[])new Object[0]);
            this.maxFilterPositionsCount = maxFilterPositionsCount;
            this.maxFilterSize = maxFilterSize;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new DynamicFilterSourceOperator(driverContext.addOperatorContext(this.operatorId, this.planNodeId, DynamicFilterSourceOperator.class.getSimpleName()), this.dynamicPredicateConsumer, this.channels, this.planNodeId, this.maxFilterPositionsCount, this.maxFilterSize);
        }

        @Override
        public void noMoreOperators() {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("duplicate() is not supported for DynamicFilterSourceOperatorFactory");
        }
    }

    public static class Channel {
        private final String filterId;
        private final Type type;
        private final int index;

        public Channel(String filterId, Type type, int index) {
            this.filterId = filterId;
            this.type = type;
            this.index = index;
        }
    }
}

