/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.TopNNode;

public class MergeLimitWithTopN
implements Rule<LimitNode> {
    private static final Capture<TopNNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.topN().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        TopNNode child = (TopNNode)captures.get(CHILD);
        if (parent.isWithTies()) {
            if (parent.getCount() < child.getCount()) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(child);
        }
        return Rule.Result.ofPlanNode(new TopNNode(parent.getId(), child.getSource(), Math.min(parent.getCount(), child.getCount()), child.getOrderingScheme(), parent.isPartial() ? TopNNode.Step.PARTIAL : TopNNode.Step.SINGLE));
    }
}

