/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import org.apache.pulsar.sql.presto.PulsarColumnMetadata;

public class PulsarColumnHandle
implements DecoderColumnHandle {
    private final String connectorId;
    private final String name;
    private final Type type;
    private final boolean hidden;
    private final boolean internal;
    private HandleKeyValueType handleKeyValueType;
    private String mapping;
    private String dataFormat;
    private String formatHint;

    @JsonCreator
    public PulsarColumnHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="internal") boolean internal, @JsonProperty(value="mapping") String mapping, @JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="formatHint") String formatHint, @JsonProperty(value="handleKeyValueType") HandleKeyValueType handleKeyValueType) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.hidden = hidden;
        this.internal = internal;
        this.mapping = mapping;
        this.dataFormat = dataFormat;
        this.formatHint = formatHint;
        this.handleKeyValueType = handleKeyValueType == null ? HandleKeyValueType.NONE : handleKeyValueType;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    @JsonProperty
    public String getFormatHint() {
        return this.formatHint;
    }

    @JsonProperty
    public HandleKeyValueType getHandleKeyValueType() {
        return this.handleKeyValueType;
    }

    @JsonIgnore
    public boolean isKey() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)HandleKeyValueType.KEY);
    }

    @JsonIgnore
    public boolean isValue() {
        return Objects.equals((Object)this.handleKeyValueType, (Object)HandleKeyValueType.VALUE);
    }

    ColumnMetadata getColumnMetadata() {
        return new PulsarColumnMetadata(this.name, this.type, null, null, this.hidden, this.internal, this.handleKeyValueType, new PulsarColumnMetadata.DecoderExtraInfo(this.mapping, this.dataFormat, this.formatHint));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PulsarColumnHandle that = (PulsarColumnHandle)o;
        if (this.hidden != that.hidden) {
            return false;
        }
        if (this.internal != that.internal) {
            return false;
        }
        if (this.connectorId != null ? !this.connectorId.equals(that.connectorId) : that.connectorId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.mapping != null ? !this.mapping.equals(that.mapping) : that.mapping != null) {
            return false;
        }
        if (this.dataFormat != null ? !this.dataFormat.equals(that.dataFormat) : that.dataFormat != null) {
            return false;
        }
        if (this.formatHint != null ? !this.formatHint.equals(that.formatHint) : that.formatHint != null) {
            return false;
        }
        return Objects.equals((Object)this.handleKeyValueType, (Object)that.handleKeyValueType);
    }

    public int hashCode() {
        int result = this.connectorId != null ? this.connectorId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.hidden ? 1 : 0);
        result = 31 * result + (this.internal ? 1 : 0);
        result = 31 * result + (this.mapping != null ? this.mapping.hashCode() : 0);
        result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
        result = 31 * result + (this.formatHint != null ? this.formatHint.hashCode() : 0);
        result = 31 * result + (this.handleKeyValueType != null ? this.handleKeyValueType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PulsarColumnHandle{connectorId='" + this.connectorId + '\'' + ", name='" + this.name + '\'' + ", type=" + this.type + ", hidden=" + this.hidden + ", internal=" + this.internal + ", mapping=" + this.mapping + ", dataFormat=" + this.dataFormat + ", formatHint=" + this.formatHint + ", handleKeyValueType=" + (Object)((Object)this.handleKeyValueType) + '}';
    }

    public static enum HandleKeyValueType {
        NONE,
        KEY,
        VALUE;

    }
}

