/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.InterpretedFunctionInvoker;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.NoOpSymbolResolver;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.type.TypeCoercion;
import java.util.Objects;
import java.util.Optional;

public class UnwrapCastInComparison
extends ExpressionRewriteRuleSet {
    public UnwrapCastInComparison(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        super(UnwrapCastInComparison.createRewrite(metadata, typeAnalyzer));
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        return (expression, context) -> UnwrapCastInComparison.unwrapCasts(context.getSession(), metadata, typeAnalyzer, context.getSymbolAllocator().getTypes(), expression);
    }

    public static Expression unwrapCasts(Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, Expression expression) {
        if (SystemSessionProperties.isUnwrapCasts(session)) {
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, typeAnalyzer, session, types), (Expression)expression);
        }
        return expression;
    }

    private static int compare(Type type, Object first, Object second) {
        return type.compareTo(Utils.nativeValueToBlock((Type)type, (Object)first), 0, Utils.nativeValueToBlock((Type)type, (Object)second), 0);
    }

    private static Expression falseIfNotNull(Expression argument) {
        return ExpressionUtils.and(new Expression[]{new IsNullPredicate(argument), new NullLiteral()});
    }

    private static Expression trueIfNotNull(Expression argument) {
        return ExpressionUtils.or(new Expression[]{new IsNotNullPredicate(argument), new NullLiteral()});
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final TypeAnalyzer typeAnalyzer;
        private final Session session;
        private final TypeProvider types;
        private final InterpretedFunctionInvoker functionInvoker;
        private final LiteralEncoder literalEncoder;

        public Visitor(Metadata metadata, TypeAnalyzer typeAnalyzer, Session session, TypeProvider types) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.functionInvoker = new InterpretedFunctionInvoker(metadata);
            this.literalEncoder = new LiteralEncoder(metadata);
        }

        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            ComparisonExpression expression = (ComparisonExpression)treeRewriter.defaultRewrite((Expression)node, null);
            return this.unwrapCast(expression);
        }

        private Expression unwrapCast(ComparisonExpression expression) {
            Object literalInSourceType;
            ResolvedFunction targetToSource;
            Type targetType;
            if (!(expression.getLeft() instanceof Cast)) {
                return expression;
            }
            Object right = ExpressionInterpreter.expressionOptimizer(expression.getRight(), this.metadata, this.session, this.typeAnalyzer.getTypes(this.session, this.types, expression.getRight())).optimize(NoOpSymbolResolver.INSTANCE);
            Cast cast = (Cast)expression.getLeft();
            ComparisonExpression.Operator operator = expression.getOperator();
            if (right == null || right instanceof NullLiteral) {
                switch (operator) {
                    case EQUAL: 
                    case NOT_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        return new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN));
                    }
                    case IS_DISTINCT_FROM: {
                        return new IsNotNullPredicate((Expression)cast);
                    }
                }
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (right instanceof Expression) {
                return expression;
            }
            Type sourceType = this.typeAnalyzer.getType(this.session, this.types, cast.getExpression());
            if (!this.hasInjectiveImplicitCoercion(sourceType, targetType = this.typeAnalyzer.getType(this.session, this.types, expression.getRight()))) {
                return expression;
            }
            ResolvedFunction sourceToTarget = this.metadata.getCoercion(sourceType, targetType);
            Optional sourceRange = sourceType.getRange();
            if (sourceRange.isPresent()) {
                Object max = ((Type.Range)sourceRange.get()).getMax();
                Object maxInTargetType = this.coerce(max, sourceToTarget);
                int upperBoundComparison = UnwrapCastInComparison.compare(targetType, right, maxInTargetType);
                if (upperBoundComparison > 0) {
                    switch (operator) {
                        case EQUAL: 
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            return UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                        }
                        case NOT_EQUAL: 
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            return UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                        }
                        case IS_DISTINCT_FROM: {
                            return BooleanLiteral.TRUE_LITERAL;
                        }
                    }
                    throw new UnsupportedOperationException("Not yet implemented: " + operator);
                }
                if (upperBoundComparison == 0) {
                    switch (operator) {
                        case GREATER_THAN: {
                            return UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(max, sourceType));
                        }
                        case LESS_THAN_OR_EQUAL: {
                            return UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                        }
                        case LESS_THAN: {
                            return new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(max, sourceType));
                        }
                        case EQUAL: 
                        case NOT_EQUAL: 
                        case IS_DISTINCT_FROM: {
                            return new ComparisonExpression(operator, cast.getExpression(), this.literalEncoder.toExpression(max, sourceType));
                        }
                    }
                    throw new UnsupportedOperationException("Not yet implemented: " + operator);
                }
                Object min = ((Type.Range)sourceRange.get()).getMin();
                Object minInTargetType = this.coerce(min, sourceToTarget);
                int lowerBoundComparison = UnwrapCastInComparison.compare(targetType, right, minInTargetType);
                if (lowerBoundComparison < 0) {
                    switch (operator) {
                        case NOT_EQUAL: 
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: {
                            return UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                        }
                        case EQUAL: 
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: {
                            return UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                        }
                        case IS_DISTINCT_FROM: {
                            return BooleanLiteral.TRUE_LITERAL;
                        }
                    }
                    throw new UnsupportedOperationException("Not yet implemented: " + operator);
                }
                if (lowerBoundComparison == 0) {
                    switch (operator) {
                        case LESS_THAN: {
                            return UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                        }
                        case LESS_THAN_OR_EQUAL: {
                            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(min, sourceType));
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            return UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                        }
                        case GREATER_THAN: {
                            return new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(min, sourceType));
                        }
                        case EQUAL: 
                        case NOT_EQUAL: 
                        case IS_DISTINCT_FROM: {
                            return new ComparisonExpression(operator, cast.getExpression(), this.literalEncoder.toExpression(min, sourceType));
                        }
                    }
                    throw new UnsupportedOperationException("Not yet implemented: " + operator);
                }
            }
            try {
                targetToSource = this.metadata.getCoercion(targetType, sourceType);
            }
            catch (OperatorNotFoundException e) {
                return expression;
            }
            try {
                literalInSourceType = this.coerce(right, targetToSource);
            }
            catch (PrestoException e) {
                return expression;
            }
            Object roundtripLiteral = this.coerce(literalInSourceType, sourceToTarget);
            int literalVsRoundtripped = UnwrapCastInComparison.compare(targetType, right, roundtripLiteral);
            if (literalVsRoundtripped > 0) {
                switch (operator) {
                    case EQUAL: {
                        return UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                    }
                    case NOT_EQUAL: {
                        return UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                    }
                    case IS_DISTINCT_FROM: {
                        return BooleanLiteral.TRUE_LITERAL;
                    }
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        if (sourceRange.isPresent() && UnwrapCastInComparison.compare(sourceType, ((Type.Range)sourceRange.get()).getMin(), literalInSourceType) == 0) {
                            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                        }
                        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                    }
                }
                throw new UnsupportedOperationException("Not yet implemented: " + operator);
            }
            if (literalVsRoundtripped < 0) {
                switch (operator) {
                    case EQUAL: {
                        return UnwrapCastInComparison.falseIfNotNull(cast.getExpression());
                    }
                    case NOT_EQUAL: {
                        return UnwrapCastInComparison.trueIfNotNull(cast.getExpression());
                    }
                    case IS_DISTINCT_FROM: {
                        return BooleanLiteral.TRUE_LITERAL;
                    }
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: {
                        if (sourceRange.isPresent() && UnwrapCastInComparison.compare(sourceType, ((Type.Range)sourceRange.get()).getMax(), literalInSourceType) == 0) {
                            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                        }
                        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
                    }
                }
                throw new UnsupportedOperationException("Not yet implemented: " + operator);
            }
            return new ComparisonExpression(operator, cast.getExpression(), this.literalEncoder.toExpression(literalInSourceType, sourceType));
        }

        private boolean hasInjectiveImplicitCoercion(Type source, Type target) {
            if (source.equals(BigintType.BIGINT) && target.equals(DoubleType.DOUBLE) || source.equals(BigintType.BIGINT) && target.equals(RealType.REAL) || source.equals(IntegerType.INTEGER) && target.equals(RealType.REAL)) {
                return false;
            }
            if (source instanceof DecimalType) {
                int precision = ((DecimalType)source).getPrecision();
                if (precision > 15 && target.equals(DoubleType.DOUBLE)) {
                    return false;
                }
                if (precision > 7 && target.equals(RealType.REAL)) {
                    return false;
                }
            }
            return new TypeCoercion(this.metadata::getType).canCoerce(source, target);
        }

        private Object coerce(Object value, ResolvedFunction coercion) {
            return this.functionInvoker.invoke(coercion, this.session.toConnectorSession(), value);
        }
    }
}

