/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Patterns;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PruneOrderByInAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final Metadata metadata;

    public PruneOrderByInAggregation(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        if (!node.hasOrderings()) {
            return Rule.Result.empty();
        }
        boolean anyRewritten = false;
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (!aggregation.getOrderingScheme().isPresent()) {
                aggregations.put(entry);
                continue;
            }
            if (this.metadata.getAggregationFunctionMetadata(aggregation.getResolvedFunction()).isOrderSensitive()) {
                aggregations.put(entry);
                continue;
            }
            anyRewritten = true;
            aggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), aggregation.getFilter(), Optional.empty(), aggregation.getMask()));
        }
        if (!anyRewritten) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AggregationNode(node.getId(), node.getSource(), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), node.getGroupingSets(), node.getPreGroupedSymbols(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol()));
    }
}

