/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.ParameterUtils;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.LogicalPlanner;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.PlanFragmenter;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.PlanOptimizers;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.planprinter.IoPlanPrinter;
import io.prestosql.sql.planner.planprinter.PlanPrinter;
import io.prestosql.sql.tree.ExplainType;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class QueryExplainer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;

    @Inject
    public QueryExplainer(PlanOptimizers planOptimizers, PlanFragmenter planFragmenter, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask) {
        this(planOptimizers.get(), planFragmenter, metadata, accessControl, sqlParser, statsCalculator, costCalculator, dataDefinitionTask);
    }

    public QueryExplainer(List<PlanOptimizer> planOptimizers, PlanFragmenter planFragmenter, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask) {
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.dataDefinitionTask = ImmutableMap.copyOf(Objects.requireNonNull(dataDefinitionTask, "dataDefinitionTask is null"));
    }

    public Analysis analyze(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this), parameters, ParameterUtils.parameterExtractor(statement, parameters), warningCollector);
        return analyzer.analyze(statement);
    }

    public String getPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata, plan.getStatsAndCosts(), session, 0, false);
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textDistributedPlan(subPlan, this.metadata, session, false);
            }
            case IO: {
                return IoPlanPrinter.textIoPlan(this.getLogicalPlan(session, statement, parameters, warningCollector), this.metadata, session);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    private static <T extends Statement> String explainTask(Statement statement, DataDefinitionTask<T> task, List<Expression> parameters) {
        return task.explain(statement, parameters);
    }

    public String getGraphvizPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizLogicalPlan(plan.getRoot(), plan.getTypes());
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizDistributedPlan(subPlan);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    public String getJsonPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case IO: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return IoPlanPrinter.textIoPlan(plan, this.metadata, session);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported explain plan type %s for JSON format", planType));
    }

    public Plan getLogicalPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Analysis analysis = this.analyze(session, statement, parameters, warningCollector);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, this.planOptimizers, idAllocator, this.metadata, new TypeAnalyzer(this.sqlParser, this.metadata), this.statsCalculator, this.costCalculator, warningCollector);
        return logicalPlanner.plan(analysis, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, true);
    }

    private SubPlan getDistributedPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
        return this.planFragmenter.createSubPlans(session, plan, false, warningCollector);
    }
}

