/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.minmaxby.LongLongState;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.RemoveInputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.type.BigintOperators;

@AggregationFunction(value="sum")
public final class LongSumAggregation {
    private LongSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState LongLongState state, @SqlType(value="bigint") long value) {
        state.setFirst(state.getFirst() + 1L);
        state.setSecond(BigintOperators.add(state.getSecond(), value));
    }

    @RemoveInputFunction
    public static void removeInput(@AggregationState LongLongState state, @SqlType(value="bigint") long value) {
        state.setFirst(state.getFirst() - 1L);
        state.setSecond(BigintOperators.subtract(state.getSecond(), value));
    }

    @CombineFunction
    public static void combine(@AggregationState LongLongState state, @AggregationState LongLongState otherState) {
        state.setFirst(state.getFirst() + otherState.getFirst());
        state.setSecond(BigintOperators.add(state.getSecond(), otherState.getSecond()));
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongLongState state, BlockBuilder out) {
        if (state.getFirst() == 0L) {
            out.appendNull();
        } else {
            BigintType.BIGINT.writeLong(out, state.getSecond());
        }
    }
}

