/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.resourcegroups;

import com.google.common.base.Preconditions;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.spi.resourcegroups.ResourceGroup;
import io.prestosql.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.resourcegroups.SelectionContext;
import io.prestosql.spi.resourcegroups.SelectionCriteria;
import java.util.Optional;
import javax.inject.Inject;

public class LegacyResourceGroupConfigurationManager
implements ResourceGroupConfigurationManager<VoidContext> {
    private static final ResourceGroupId GLOBAL = new ResourceGroupId("global");
    private final int hardConcurrencyLimit;
    private final int maxQueued;

    @Inject
    public LegacyResourceGroupConfigurationManager(QueryManagerConfig config) {
        this.hardConcurrencyLimit = config.getMaxConcurrentQueries();
        this.maxQueued = config.getMaxQueuedQueries();
    }

    public void configure(ResourceGroup group, SelectionContext<VoidContext> criteria) {
        Preconditions.checkArgument((boolean)group.getId().equals((Object)GLOBAL), (String)"Unexpected resource group: %s", (Object)group.getId());
        group.setMaxQueuedQueries(this.maxQueued);
        group.setHardConcurrencyLimit(this.hardConcurrencyLimit);
    }

    public Optional<SelectionContext<VoidContext>> match(SelectionCriteria criteria) {
        return Optional.of(new SelectionContext(GLOBAL, (Object)VoidContext.NONE));
    }

    public SelectionContext<VoidContext> parentGroupContext(SelectionContext<VoidContext> context) {
        return new SelectionContext((ResourceGroupId)context.getResourceGroupId().getParent().orElseThrow(() -> new IllegalArgumentException("Group has no parent group: " + context.getResourceGroupId())), (Object)VoidContext.NONE);
    }

    static enum VoidContext {
        NONE;

    }
}

