/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing.assertions;

import io.airlift.units.Duration;

public class Assert
extends org.testng.Assert {
    private Assert() {
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected, String message) {
        try {
            org.testng.Assert.assertEquals(actual, expected, (String)message);
        }
        catch (AssertionError error) {
            org.testng.Assert.assertEquals(actual, expected, (String)message);
            throw error;
        }
    }

    public static void assertEventually(Duration timeout, Runnable assertion) {
        long start = System.nanoTime();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                assertion.run();
                return;
            }
            catch (AssertionError | Exception e) {
                if (Duration.nanosSince((long)start).compareTo(timeout) > 0) {
                    throw e;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
    }
}

