/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LimitNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final Optional<OrderingScheme> tiesResolvingScheme;
    private final boolean partial;

    public LimitNode(PlanNodeId id, PlanNode source, long count, boolean partial) {
        this(id, source, count, Optional.empty(), partial);
    }

    @JsonCreator
    public LimitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="tiesResolvingScheme") Optional<OrderingScheme> tiesResolvingScheme, @JsonProperty(value="partial") boolean partial) {
        super(id);
        this.partial = partial;
        Objects.requireNonNull(source, "source is null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must be greater than or equal to zero");
        Objects.requireNonNull(tiesResolvingScheme, "tiesResolvingScheme is null");
        this.source = source;
        this.count = count;
        this.tiesResolvingScheme = tiesResolvingScheme;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    public boolean isWithTies() {
        return this.tiesResolvingScheme.isPresent();
    }

    @JsonProperty
    public Optional<OrderingScheme> getTiesResolvingScheme() {
        return this.tiesResolvingScheme;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new LimitNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.count, this.tiesResolvingScheme, this.isPartial());
    }
}

