/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class ProjectOffPushDownRule<N extends PlanNode>
implements Rule<ProjectNode> {
    private final Capture<N> targetCapture = Capture.newCapture();
    private final Pattern<N> targetPattern;

    protected ProjectOffPushDownRule(Pattern<N> targetPattern) {
        this.targetPattern = targetPattern;
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(this.targetPattern.capturedAs(this.targetCapture)));
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        PlanNode targetNode = (PlanNode)captures.get(this.targetCapture);
        return Util.pruneInputs(targetNode.getOutputSymbols(), parent.getAssignments().getExpressions()).flatMap(prunedOutputs -> this.pushDownProjectOff(context, (N)targetNode, (Set<Symbol>)prunedOutputs)).map(newChild -> parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)newChild))).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    protected abstract Optional<PlanNode> pushDownProjectOff(Rule.Context var1, N var2, Set<Symbol> var3);
}

