/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.client.impl.Backoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtil {
    private static final Logger log = LoggerFactory.getLogger(RetryUtil.class);

    public static <T> void retryAsynchronously(Supplier<T> supplier, Backoff backoff, ScheduledExecutorService scheduledExecutorService, CompletableFuture<T> callback) {
        if (backoff.getMax() <= 0L) {
            throw new IllegalArgumentException("Illegal max retry time");
        }
        if (backoff.getInitial() <= 0L) {
            throw new IllegalArgumentException("Illegal initial time");
        }
        scheduledExecutorService.execute(() -> RetryUtil.executeWithRetry(supplier, backoff, scheduledExecutorService, callback));
    }

    private static <T> void executeWithRetry(Supplier<T> supplier, Backoff backoff, ScheduledExecutorService scheduledExecutorService, CompletableFuture<T> callback) {
        try {
            T result = supplier.get();
            callback.complete(result);
        }
        catch (Exception e) {
            long next = backoff.next();
            boolean isMandatoryStop = backoff.isMandatoryStopMade();
            if (isMandatoryStop) {
                callback.completeExceptionally(e);
            }
            if (log.isDebugEnabled()) {
                log.debug("execute with retry fail, will retry in {} ms", (Object)next, (Object)e);
            }
            log.info("Because of {} , will retry in {} ms", (Object)e.getMessage(), (Object)next);
            scheduledExecutorService.schedule(() -> RetryUtil.executeWithRetry(supplier, backoff, scheduledExecutorService, callback), next, TimeUnit.MILLISECONDS);
        }
    }
}

