/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import io.airlift.http.server.DoubleSummaryStats;
import io.airlift.http.server.Inet4Networks;
import io.airlift.http.server.TimingFilter;
import io.airlift.tracetoken.TraceTokenManager;
import java.security.Principal;
import java.time.Instant;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

@EventType(value="HttpRequest")
public class HttpRequestEvent {
    private final Instant timeStamp;
    private final String traceToken;
    private final String clientAddress;
    private final String protocol;
    private final String method;
    private final String requestUri;
    private final String user;
    private final String agent;
    private final String referrer;
    private final long requestSize;
    private final String requestContentType;
    private final long responseSize;
    private final int responseCode;
    private final String responseContentType;
    private final long timeToDispatch;
    private final Long timeToFirstByte;
    private final long timeToLastByte;
    private final long beginToDispatchMillis;
    private final long beginToEndMillis;
    private final long firstToLastContentTimeInMillis;
    private final DoubleSummaryStats responseContentInterarrivalStats;
    private final String protocolVersion;

    public static HttpRequestEvent createHttpRequestEvent(Request request, Response response, TraceTokenManager traceTokenManager, long currentTimeInMillis, long beginToDispatchMillis, long beginToEndMillis, long firstToLastContentTimeInMillis, DoubleSummaryStats responseContentInterarrivalStats) {
        String protocol;
        String method;
        String token;
        String user = null;
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            user = principal.getName();
        }
        if ((token = request.getHeader("X-Airlift-TraceToken")) == null && traceTokenManager != null) {
            token = traceTokenManager.getCurrentRequestToken();
        }
        long dispatchTime = request.getTimeStamp();
        long timeToDispatch = Math.max(dispatchTime - request.getTimeStamp(), 0L);
        Long timeToFirstByte = null;
        Object firstByteTime = request.getAttribute(TimingFilter.FIRST_BYTE_TIME);
        if (firstByteTime instanceof Long) {
            Long time = (Long)firstByteTime;
            timeToFirstByte = Math.max(time - request.getTimeStamp(), 0L);
        }
        long timeToLastByte = Math.max(currentTimeInMillis - request.getTimeStamp(), 0L);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (request.getRemoteAddr() != null) {
            builder.add((Object)request.getRemoteAddr());
        }
        Enumeration e = request.getHeaders("X-FORWARDED-FOR");
        while (e != null && e.hasMoreElements()) {
            String forwardedFor = (String)e.nextElement();
            builder.addAll(Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)forwardedFor));
        }
        String clientAddress = null;
        ImmutableList clientAddresses = builder.build();
        for (String address : Lists.reverse((List)clientAddresses)) {
            try {
                if (Inet4Networks.isPrivateNetworkAddress(address)) continue;
                clientAddress = address;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (clientAddress == null) {
            clientAddress = request.getRemoteAddr();
        }
        String requestUri = null;
        if (request.getRequestURI() != null) {
            requestUri = request.getRequestURI();
            String parameters = request.getQueryString();
            if (parameters != null) {
                requestUri = requestUri + "?" + parameters;
            }
        }
        if ((method = request.getMethod()) != null) {
            method = method.toUpperCase();
        }
        if ((protocol = request.getHeader("X-FORWARDED-PROTO")) == null) {
            protocol = request.getScheme();
        }
        if (protocol != null) {
            protocol = protocol.toLowerCase();
        }
        return new HttpRequestEvent(Instant.ofEpochMilli(request.getTimeStamp()), token, clientAddress, protocol, method, requestUri, user, request.getHeader("User-Agent"), request.getHeader("Referer"), request.getContentRead(), request.getHeader("Content-Type"), response.getContentCount(), response.getStatus(), response.getHeader("Content-Type"), timeToDispatch, timeToFirstByte, timeToLastByte, beginToDispatchMillis, beginToEndMillis, firstToLastContentTimeInMillis, responseContentInterarrivalStats, request.getHttpVersion().toString());
    }

    public HttpRequestEvent(Instant timeStamp, String traceToken, String clientAddress, String protocol, String method, String requestUri, String user, String agent, String referrer, long requestSize, String requestContentType, long responseSize, int responseCode, String responseContentType, long timeToDispatch, Long timeToFirstByte, long timeToLastByte, long beginToDispatchMillis, long beginToEndMillis, long firstToLastContentTimeInMillis, DoubleSummaryStats responseContentInterarrivalStats, String protocolVersion) {
        this.timeStamp = timeStamp;
        this.traceToken = traceToken;
        this.clientAddress = clientAddress;
        this.protocol = protocol;
        this.method = method;
        this.requestUri = requestUri;
        this.user = user;
        this.agent = agent;
        this.referrer = referrer;
        this.requestSize = requestSize;
        this.requestContentType = requestContentType;
        this.responseSize = responseSize;
        this.responseCode = responseCode;
        this.responseContentType = responseContentType;
        this.timeToDispatch = timeToDispatch;
        this.timeToFirstByte = timeToFirstByte;
        this.timeToLastByte = timeToLastByte;
        this.beginToDispatchMillis = beginToDispatchMillis;
        this.beginToEndMillis = beginToEndMillis;
        this.firstToLastContentTimeInMillis = firstToLastContentTimeInMillis;
        this.responseContentInterarrivalStats = responseContentInterarrivalStats;
        this.protocolVersion = protocolVersion;
    }

    @EventField(fieldMapping=EventField.EventFieldMapping.TIMESTAMP)
    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    @EventField
    public String getTraceToken() {
        return this.traceToken;
    }

    @EventField
    public String getClientAddress() {
        return this.clientAddress;
    }

    @EventField
    public String getProtocol() {
        return this.protocol;
    }

    @EventField
    public String getMethod() {
        return this.method;
    }

    @EventField
    public String getRequestUri() {
        return this.requestUri;
    }

    @EventField
    public String getUser() {
        return this.user;
    }

    @EventField
    public String getAgent() {
        return this.agent;
    }

    @EventField
    public String getReferrer() {
        return this.referrer;
    }

    @EventField
    public long getRequestSize() {
        return this.requestSize;
    }

    @EventField
    public String getRequestContentType() {
        return this.requestContentType;
    }

    @EventField
    public long getResponseSize() {
        return this.responseSize;
    }

    @EventField
    public int getResponseCode() {
        return this.responseCode;
    }

    @EventField
    public String getResponseContentType() {
        return this.responseContentType;
    }

    @EventField
    public long getTimeToDispatch() {
        return this.timeToDispatch;
    }

    @EventField
    public Long getTimeToFirstByte() {
        return this.timeToFirstByte;
    }

    @EventField
    public long getTimeToLastByte() {
        return this.timeToLastByte;
    }

    @EventField
    public long getBeginToDispatchMillis() {
        return this.beginToDispatchMillis;
    }

    @EventField
    public long getBeginToEndMillis() {
        return this.beginToEndMillis;
    }

    @EventField
    public long getFirstToLastContentTimeInMillis() {
        return this.firstToLastContentTimeInMillis;
    }

    @EventField
    public DoubleSummaryStats getResponseContentInterarrivalStats() {
        return this.responseContentInterarrivalStats;
    }

    @EventField
    public String getProtocolVersion() {
        return this.protocolVersion;
    }
}

