/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneApplySourceColumns
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        Set subqueryAssignmentsSymbols = (Set)applyNode.getSubqueryAssignments().getExpressions().stream().flatMap(expression -> SymbolsExtractor.extractUnique(expression).stream()).collect(ImmutableSet.toImmutableSet());
        Optional<PlanNode> prunedSubquery = Util.restrictOutputs(context.getIdAllocator(), applyNode.getSubquery(), subqueryAssignmentsSymbols);
        return prunedSubquery.map(subquery -> applyNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)applyNode.getInput(), (Object)subquery))).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

