/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.BlockComparator;
import io.prestosql.operator.aggregation.TypedHeap;
import io.prestosql.operator.aggregation.state.MinMaxNState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import java.util.List;

public class MinMaxNStateSerializer
implements AccumulatorStateSerializer<MinMaxNState> {
    private final BlockComparator blockComparator;
    private final Type elementType;
    private final ArrayType arrayType;
    private final Type serializedType;

    public MinMaxNStateSerializer(BlockComparator blockComparator, Type elementType) {
        this.blockComparator = blockComparator;
        this.elementType = elementType;
        this.arrayType = new ArrayType(elementType);
        this.serializedType = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)this.arrayType));
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(MinMaxNState state, BlockBuilder out) {
        TypedHeap heap = state.getTypedHeap();
        if (heap == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        BigintType.BIGINT.writeLong(blockBuilder, (long)heap.getCapacity());
        BlockBuilder elements = blockBuilder.beginBlockEntry();
        heap.writeAll(elements);
        blockBuilder.closeEntry();
        out.closeEntry();
    }

    public void deserialize(Block block, int index, MinMaxNState state) {
        Block currentBlock = (Block)this.serializedType.getObject(block, index);
        int capacity = Math.toIntExact(BigintType.BIGINT.getLong(currentBlock, 0));
        Block heapBlock = this.arrayType.getObject(currentBlock, 1);
        TypedHeap heap = new TypedHeap(this.blockComparator, this.elementType, capacity);
        heap.addAll(heapBlock);
        state.setTypedHeap(heap);
    }
}

