/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.execution.BasicStageStats;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.RemoteTask;
import io.prestosql.execution.RemoteTaskFactory;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.StageState;
import io.prestosql.execution.StageStateMachine;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.TableInfo;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskState;
import io.prestosql.execution.TaskStatus;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.scheduler.SplitSchedulerStats;
import io.prestosql.failuredetector.FailureDetector;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.Split;
import io.prestosql.operator.ExchangeOperator;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.split.RemoteSplit;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SqlStageExecution {
    private final StageStateMachine stateMachine;
    private final RemoteTaskFactory remoteTaskFactory;
    private final NodeTaskMap nodeTaskMap;
    private final boolean summarizeTaskInfo;
    private final Executor executor;
    private final FailureDetector failureDetector;
    private final Map<PlanFragmentId, RemoteSourceNode> exchangeSources;
    private final Map<InternalNode, Set<RemoteTask>> tasks = new ConcurrentHashMap<InternalNode, Set<RemoteTask>>();
    @GuardedBy(value="this")
    private final AtomicInteger nextTaskId = new AtomicInteger();
    @GuardedBy(value="this")
    private final Set<TaskId> allTasks = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private final Set<TaskId> finishedTasks = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private final Set<TaskId> tasksWithFinalInfo = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private final AtomicBoolean splitsScheduled = new AtomicBoolean();
    @GuardedBy(value="this")
    private final Multimap<PlanNodeId, RemoteTask> sourceTasks = HashMultimap.create();
    @GuardedBy(value="this")
    private final Set<PlanNodeId> completeSources = Sets.newConcurrentHashSet();
    @GuardedBy(value="this")
    private final Set<PlanFragmentId> completeSourceFragments = Sets.newConcurrentHashSet();
    private final AtomicReference<OutputBuffers> outputBuffers = new AtomicReference();
    private final ListenerManager<Set<Lifespan>> completedLifespansChangeListeners = new ListenerManager();

    public static SqlStageExecution createSqlStageExecution(StageId stageId, PlanFragment fragment, Map<PlanNodeId, TableInfo> tables, RemoteTaskFactory remoteTaskFactory, Session session, boolean summarizeTaskInfo, NodeTaskMap nodeTaskMap, ExecutorService executor, FailureDetector failureDetector, SplitSchedulerStats schedulerStats) {
        Objects.requireNonNull(stageId, "stageId is null");
        Objects.requireNonNull(fragment, "fragment is null");
        Objects.requireNonNull(tables, "tables is null");
        Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(failureDetector, "failureDetector is null");
        Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        SqlStageExecution sqlStageExecution = new SqlStageExecution(new StageStateMachine(stageId, session, fragment, tables, executor, schedulerStats), remoteTaskFactory, nodeTaskMap, summarizeTaskInfo, executor, failureDetector);
        sqlStageExecution.initialize();
        return sqlStageExecution;
    }

    private SqlStageExecution(StageStateMachine stateMachine, RemoteTaskFactory remoteTaskFactory, NodeTaskMap nodeTaskMap, boolean summarizeTaskInfo, Executor executor, FailureDetector failureDetector) {
        this.stateMachine = stateMachine;
        this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.summarizeTaskInfo = summarizeTaskInfo;
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
        ImmutableMap.Builder fragmentToExchangeSource = ImmutableMap.builder();
        for (RemoteSourceNode remoteSourceNode : stateMachine.getFragment().getRemoteSourceNodes()) {
            for (PlanFragmentId planFragmentId : remoteSourceNode.getSourceFragmentIds()) {
                fragmentToExchangeSource.put((Object)planFragmentId, (Object)remoteSourceNode);
            }
        }
        this.exchangeSources = fragmentToExchangeSource.build();
    }

    private void initialize() {
        this.stateMachine.addStateChangeListener(newState -> this.checkAllTaskFinal());
    }

    public StageId getStageId() {
        return this.stateMachine.getStageId();
    }

    public StageState getState() {
        return this.stateMachine.getState();
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<StageState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    public void addFinalStageInfoListener(StateMachine.StateChangeListener<StageInfo> stateChangeListener) {
        this.stateMachine.addFinalStageInfoListener(stateChangeListener);
    }

    public void addCompletedDriverGroupsChangedListener(Consumer<Set<Lifespan>> newlyCompletedDriverGroupConsumer) {
        this.completedLifespansChangeListeners.addListener(newlyCompletedDriverGroupConsumer);
    }

    public PlanFragment getFragment() {
        return this.stateMachine.getFragment();
    }

    public OutputBuffers getOutputBuffers() {
        return this.outputBuffers.get();
    }

    public void beginScheduling() {
        this.stateMachine.transitionToScheduling();
    }

    public synchronized void transitionToSchedulingSplits() {
        this.stateMachine.transitionToSchedulingSplits();
    }

    public synchronized void schedulingComplete() {
        if (!this.stateMachine.transitionToScheduled()) {
            return;
        }
        if (this.getAllTasks().stream().anyMatch(task -> this.getState() == StageState.RUNNING)) {
            this.stateMachine.transitionToRunning();
        }
        if (this.finishedTasks.containsAll(this.allTasks)) {
            this.stateMachine.transitionToFinished();
        }
        for (PlanNodeId partitionedSource : this.stateMachine.getFragment().getPartitionedSources()) {
            this.schedulingComplete(partitionedSource);
        }
    }

    public synchronized void schedulingComplete(PlanNodeId partitionedSource) {
        for (RemoteTask task : this.getAllTasks()) {
            task.noMoreSplits(partitionedSource);
        }
        this.completeSources.add(partitionedSource);
    }

    public synchronized void cancel() {
        this.stateMachine.transitionToCanceled();
        this.getAllTasks().forEach(RemoteTask::cancel);
    }

    public synchronized void abort() {
        this.stateMachine.transitionToAborted();
        this.getAllTasks().forEach(RemoteTask::abort);
    }

    public long getUserMemoryReservation() {
        return this.stateMachine.getUserMemoryReservation();
    }

    public long getTotalMemoryReservation() {
        return this.stateMachine.getTotalMemoryReservation();
    }

    public synchronized Duration getTotalCpuTime() {
        long millis = this.getAllTasks().stream().mapToLong(task -> task.getTaskInfo().getStats().getTotalCpuTime().toMillis()).sum();
        return new Duration((double)millis, TimeUnit.MILLISECONDS);
    }

    public BasicStageStats getBasicStageStats() {
        return this.stateMachine.getBasicStageStats(this::getAllTaskInfo);
    }

    public StageInfo getStageInfo() {
        return this.stateMachine.getStageInfo(this::getAllTaskInfo);
    }

    private Iterable<TaskInfo> getAllTaskInfo() {
        return (Iterable)this.getAllTasks().stream().map(RemoteTask::getTaskInfo).collect(ImmutableList.toImmutableList());
    }

    public synchronized void addExchangeLocations(PlanFragmentId fragmentId, Set<RemoteTask> sourceTasks, boolean noMoreExchangeLocations) {
        Objects.requireNonNull(fragmentId, "fragmentId is null");
        Objects.requireNonNull(sourceTasks, "sourceTasks is null");
        RemoteSourceNode remoteSource = this.exchangeSources.get(fragmentId);
        Preconditions.checkArgument((remoteSource != null ? 1 : 0) != 0, (String)"Unknown remote source %s. Known sources are %s", (Object)fragmentId, this.exchangeSources.keySet());
        this.sourceTasks.putAll((Object)remoteSource.getId(), sourceTasks);
        for (RemoteTask task : this.getAllTasks()) {
            ImmutableMultimap.Builder newSplits = ImmutableMultimap.builder();
            for (RemoteTask sourceTask : sourceTasks) {
                URI exchangeLocation = sourceTask.getTaskStatus().getSelf();
                newSplits.put((Object)remoteSource.getId(), (Object)SqlStageExecution.createRemoteSplitFor(task.getTaskId(), exchangeLocation));
            }
            task.addSplits((Multimap<PlanNodeId, Split>)newSplits.build());
        }
        if (noMoreExchangeLocations) {
            this.completeSourceFragments.add(fragmentId);
            if (this.completeSourceFragments.containsAll(remoteSource.getSourceFragmentIds())) {
                this.completeSources.add(remoteSource.getId());
                for (RemoteTask task : this.getAllTasks()) {
                    task.noMoreSplits(remoteSource.getId());
                }
            }
        }
    }

    public synchronized void setOutputBuffers(OutputBuffers outputBuffers) {
        OutputBuffers currentOutputBuffers;
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        do {
            if ((currentOutputBuffers = this.outputBuffers.get()) == null) continue;
            if (outputBuffers.getVersion() <= currentOutputBuffers.getVersion()) {
                return;
            }
            currentOutputBuffers.checkValidTransition(outputBuffers);
        } while (!this.outputBuffers.compareAndSet(currentOutputBuffers, outputBuffers));
        for (RemoteTask task : this.getAllTasks()) {
            task.setOutputBuffers(outputBuffers);
        }
    }

    public boolean hasTasks() {
        return !this.tasks.isEmpty();
    }

    public List<RemoteTask> getAllTasks() {
        return (List)this.tasks.values().stream().flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public synchronized Optional<RemoteTask> scheduleTask(InternalNode node, int partition, OptionalInt totalPartitions) {
        Objects.requireNonNull(node, "node is null");
        if (this.stateMachine.getState().isDone()) {
            return Optional.empty();
        }
        Preconditions.checkState((!this.splitsScheduled.get() ? 1 : 0) != 0, (Object)"scheduleTask cannot be called once splits have been scheduled");
        return Optional.of(this.scheduleTask(node, new TaskId(this.stateMachine.getStageId(), partition), (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), totalPartitions));
    }

    public synchronized Set<RemoteTask> scheduleSplits(InternalNode node, Multimap<PlanNodeId, Split> splits, Multimap<PlanNodeId, Lifespan> noMoreSplitsNotification) {
        RemoteTask task;
        Objects.requireNonNull(node, "node is null");
        Objects.requireNonNull(splits, "splits is null");
        if (this.stateMachine.getState().isDone()) {
            return ImmutableSet.of();
        }
        this.splitsScheduled.set(true);
        Preconditions.checkArgument((boolean)this.stateMachine.getFragment().getPartitionedSources().containsAll(splits.keySet()), (Object)"Invalid splits");
        ImmutableSet.Builder newTasks = ImmutableSet.builder();
        Collection tasks = this.tasks.get(node);
        if (tasks == null) {
            TaskId taskId = new TaskId(this.stateMachine.getStageId(), this.nextTaskId.getAndIncrement());
            task = this.scheduleTask(node, taskId, splits, OptionalInt.empty());
            newTasks.add((Object)task);
        } else {
            task = (RemoteTask)tasks.iterator().next();
            task.addSplits(splits);
        }
        if (noMoreSplitsNotification.size() > 1) {
            throw new UnsupportedOperationException("This assumption no longer holds: noMoreSplitsNotification.size() < 1");
        }
        for (Map.Entry entry : noMoreSplitsNotification.entries()) {
            task.noMoreSplits((PlanNodeId)entry.getKey(), (Lifespan)entry.getValue());
        }
        return newTasks.build();
    }

    private synchronized RemoteTask scheduleTask(InternalNode node, TaskId taskId, Multimap<PlanNodeId, Split> sourceSplits, OptionalInt totalPartitions) {
        Preconditions.checkArgument((!this.allTasks.contains(taskId) ? 1 : 0) != 0, (String)"A task with id %s already exists", (Object)taskId);
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        initialSplits.putAll(sourceSplits);
        this.sourceTasks.forEach((planNodeId, task) -> {
            TaskStatus status = task.getTaskStatus();
            if (status.getState() != TaskState.FINISHED) {
                initialSplits.put(planNodeId, (Object)SqlStageExecution.createRemoteSplitFor(taskId, status.getSelf()));
            }
        });
        OutputBuffers outputBuffers = this.outputBuffers.get();
        Preconditions.checkState((outputBuffers != null ? 1 : 0) != 0, (Object)"Initial output buffers must be set before a task can be scheduled");
        RemoteTask task2 = this.remoteTaskFactory.createRemoteTask(this.stateMachine.getSession(), taskId, node, this.stateMachine.getFragment(), (Multimap<PlanNodeId, Split>)initialSplits.build(), totalPartitions, outputBuffers, this.nodeTaskMap.createPartitionedSplitCountTracker(node, taskId), this.summarizeTaskInfo);
        this.completeSources.forEach(task2::noMoreSplits);
        this.allTasks.add(taskId);
        this.tasks.computeIfAbsent(node, key -> Sets.newConcurrentHashSet()).add(task2);
        this.nodeTaskMap.addTask(node, task2);
        task2.addStateChangeListener(new StageTaskListener());
        task2.addFinalTaskInfoListener(this::updateFinalTaskInfo);
        if (!this.stateMachine.getState().isDone()) {
            task2.start();
        } else {
            task2.abort();
        }
        return task2;
    }

    public Set<InternalNode> getScheduledNodes() {
        return ImmutableSet.copyOf(this.tasks.keySet());
    }

    public void recordGetSplitTime(long start) {
        this.stateMachine.recordGetSplitTime(start);
    }

    private static Split createRemoteSplitFor(TaskId taskId, URI taskLocation) {
        URI splitLocation = HttpUriBuilder.uriBuilderFrom((URI)taskLocation).appendPath("results").appendPath(String.valueOf(taskId.getId())).build();
        return new Split(ExchangeOperator.REMOTE_CONNECTOR_ID, new RemoteSplit(splitLocation), Lifespan.taskWide());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateTaskStatus(TaskStatus taskStatus) {
        try {
            StageState stageState = this.getState();
            if (stageState.isDone()) {
                return;
            }
            TaskState taskState = taskStatus.getState();
            if (taskState == TaskState.FAILED) {
                RuntimeException failure = taskStatus.getFailures().stream().findFirst().map(this::rewriteTransportFailure).map(ExecutionFailureInfo::toException).orElse((RuntimeException)((Object)new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "A task failed for an unknown reason")));
                this.stateMachine.transitionToFailed(failure);
            } else if (taskState == TaskState.ABORTED) {
                this.stateMachine.transitionToFailed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "A task is in the ABORTED state but stage is " + (Object)((Object)stageState)));
            } else if (taskState == TaskState.FINISHED) {
                this.finishedTasks.add(taskStatus.getTaskId());
            }
            if (stageState == StageState.SCHEDULED || stageState == StageState.RUNNING) {
                if (taskState == TaskState.RUNNING) {
                    this.stateMachine.transitionToRunning();
                }
                if (this.finishedTasks.containsAll(this.allTasks)) {
                    this.stateMachine.transitionToFinished();
                }
            }
        }
        finally {
            this.checkAllTaskFinal();
        }
    }

    private synchronized void updateFinalTaskInfo(TaskInfo finalTaskInfo) {
        this.tasksWithFinalInfo.add(finalTaskInfo.getTaskStatus().getTaskId());
        this.checkAllTaskFinal();
    }

    private synchronized void checkAllTaskFinal() {
        if (this.stateMachine.getState().isDone() && this.tasksWithFinalInfo.containsAll(this.allTasks)) {
            List finalTaskInfos = (List)this.getAllTasks().stream().map(RemoteTask::getTaskInfo).collect(ImmutableList.toImmutableList());
            this.stateMachine.setAllTasksFinal(finalTaskInfos);
        }
    }

    private ExecutionFailureInfo rewriteTransportFailure(ExecutionFailureInfo executionFailureInfo) {
        if (executionFailureInfo.getRemoteHost() == null || this.failureDetector.getState(executionFailureInfo.getRemoteHost()) != FailureDetector.State.GONE) {
            return executionFailureInfo;
        }
        return new ExecutionFailureInfo(executionFailureInfo.getType(), executionFailureInfo.getMessage(), executionFailureInfo.getCause(), executionFailureInfo.getSuppressed(), executionFailureInfo.getStack(), executionFailureInfo.getErrorLocation(), StandardErrorCode.REMOTE_HOST_GONE.toErrorCode(), executionFailureInfo.getRemoteHost());
    }

    public String toString() {
        return this.stateMachine.toString();
    }

    private static class ListenerManager<T> {
        private final List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();
        private boolean frozen;

        private ListenerManager() {
        }

        public synchronized void addListener(Consumer<T> listener) {
            Preconditions.checkState((!this.frozen ? 1 : 0) != 0, (Object)"Listeners have been invoked");
            this.listeners.add(listener);
        }

        public synchronized void invoke(T payload, Executor executor) {
            this.frozen = true;
            for (Consumer listener : this.listeners) {
                executor.execute(() -> listener.accept(payload));
            }
        }
    }

    private class StageTaskListener
    implements StateMachine.StateChangeListener<TaskStatus> {
        private long previousUserMemory;
        private long previousSystemMemory;
        private long previousRevocableMemory;
        private final Set<Lifespan> completedDriverGroups = new HashSet<Lifespan>();

        private StageTaskListener() {
        }

        @Override
        public void stateChanged(TaskStatus taskStatus) {
            try {
                this.updateMemoryUsage(taskStatus);
                this.updateCompletedDriverGroups(taskStatus);
            }
            finally {
                SqlStageExecution.this.updateTaskStatus(taskStatus);
            }
        }

        private synchronized void updateMemoryUsage(TaskStatus taskStatus) {
            long currentUserMemory = taskStatus.getMemoryReservation().toBytes();
            long currentSystemMemory = taskStatus.getSystemMemoryReservation().toBytes();
            long currentRevocableMemory = taskStatus.getRevocableMemoryReservation().toBytes();
            long deltaUserMemoryInBytes = currentUserMemory - this.previousUserMemory;
            long deltaRevocableMemoryInBytes = currentRevocableMemory - this.previousRevocableMemory;
            long deltaTotalMemoryInBytes = currentUserMemory + currentSystemMemory + currentRevocableMemory - (this.previousUserMemory + this.previousSystemMemory + this.previousRevocableMemory);
            this.previousUserMemory = currentUserMemory;
            this.previousSystemMemory = currentSystemMemory;
            this.previousRevocableMemory = currentRevocableMemory;
            SqlStageExecution.this.stateMachine.updateMemoryUsage(deltaUserMemoryInBytes, deltaRevocableMemoryInBytes, deltaTotalMemoryInBytes);
        }

        private synchronized void updateCompletedDriverGroups(TaskStatus taskStatus) {
            ImmutableSet newlyCompletedDriverGroups = ImmutableSet.copyOf((Collection)Sets.difference(taskStatus.getCompletedDriverGroups(), this.completedDriverGroups));
            if (newlyCompletedDriverGroups.isEmpty()) {
                return;
            }
            SqlStageExecution.this.completedLifespansChangeListeners.invoke(newlyCompletedDriverGroups, SqlStageExecution.this.executor);
            this.completedDriverGroups.addAll((Collection<Lifespan>)newlyCompletedDriverGroups);
        }
    }
}

