/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.resourcegroups;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import java.util.Objects;

public class QueryQueueFullException
extends PrestoException {
    private final ResourceGroupId resourceGroup;

    public QueryQueueFullException(ResourceGroupId resourceGroup) {
        super((ErrorCodeSupplier)StandardErrorCode.QUERY_QUEUE_FULL, String.format("Too many queued queries for \"%s\"", resourceGroup));
        this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup is null");
    }

    public ResourceGroupId getResourceGroup() {
        return this.resourceGroup;
    }
}

