/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx.http.rpc;

import io.airlift.jmx.http.rpc.HttpMBeanServerCredentials;
import io.airlift.jmx.http.rpc.HttpMBeanServerRpc;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.inject.Inject;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXServerErrorException;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/jmx/mbeanServer")
public class MBeanServerResource {
    private final MBeanServer mbeanServer;
    private final HttpMBeanServerCredentials credentials;

    @Inject
    public MBeanServerResource(MBeanServer mbeanServer, HttpMBeanServerCredentials credentials) {
        this.mbeanServer = mbeanServer;
        this.credentials = credentials;
    }

    @POST
    @Path(value="{method}")
    public Response invoke(@PathParam(value="method") String method, InputStream in, @HeaderParam(value="Authorization") String authHeader) throws Exception {
        Object[] args;
        if (this.credentials != null && !this.credentials.authenticate(HttpMBeanServerCredentials.fromBasicAuthHeader(authHeader))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)HttpMBeanServerRpc.createExceptionResponse(new SecurityException("Invalid credentials"))).build();
        }
        if (method == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)HttpMBeanServerRpc.createExceptionResponse(new NullPointerException("method is null"))).build();
        }
        try {
            args = (Object[])new ObjectInputStream(in).readObject();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)HttpMBeanServerRpc.createExceptionResponse(new IllegalArgumentException("Request does not contain a serialized Object[]"))).build();
        }
        try {
            Object result = null;
            if ("getMBeanInfo".equals(method)) {
                result = this.mbeanServer.getMBeanInfo((ObjectName)args[0]);
            } else if ("queryMBeans".equals(method)) {
                result = this.mbeanServer.queryMBeans((ObjectName)args[0], (QueryExp)args[1]);
            } else if ("queryNames".equals(method)) {
                result = this.mbeanServer.queryNames((ObjectName)args[0], (QueryExp)args[1]);
            } else if ("getAttribute".equals(method)) {
                result = this.mbeanServer.getAttribute((ObjectName)args[0], (String)args[1]);
            } else if ("getAttributes".equals(method)) {
                result = this.mbeanServer.getAttributes((ObjectName)args[0], (String[])args[1]);
            } else if ("setAttribute".equals(method)) {
                this.mbeanServer.setAttribute((ObjectName)args[0], (Attribute)args[1]);
            } else if ("setAttributes".equals(method)) {
                result = this.mbeanServer.setAttributes((ObjectName)args[0], (AttributeList)args[1]);
            } else if ("invoke".equals(method)) {
                result = this.mbeanServer.invoke((ObjectName)args[0], (String)args[1], (Object[])args[2], (String[])args[3]);
            } else if ("getMBeanCount".equals(method)) {
                result = this.mbeanServer.getMBeanCount();
            } else if ("isRegistered".equals(method)) {
                result = this.mbeanServer.isRegistered((ObjectName)args[0]);
            } else if ("getObjectInstance".equals(method)) {
                result = this.mbeanServer.getObjectInstance((ObjectName)args[0]);
            } else if ("getDefaultDomain".equals(method)) {
                result = this.mbeanServer.getDefaultDomain();
            } else if ("getDomains".equals(method)) {
                result = this.mbeanServer.getDomains();
            } else if ("isInstanceOf".equals(method)) {
                result = this.mbeanServer.isInstanceOf((ObjectName)args[0], (String)args[1]);
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)HttpMBeanServerRpc.createExceptionResponse(new IllegalArgumentException("Unknown method " + method))).build();
            }
            return Response.ok((Object)HttpMBeanServerRpc.createSuccessResponse(result)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)HttpMBeanServerRpc.createExceptionResponse(e)).build();
        }
        catch (Error e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)HttpMBeanServerRpc.createExceptionResponse(new JMXServerErrorException("Internal error", e))).build();
        }
    }
}

