/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.BatchReceivePolicy;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderListener;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.client.impl.conf.ReaderConfigurationData;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.naming.TopicName;

public class ReaderImpl<T>
implements Reader<T> {
    private static final BatchReceivePolicy DISABLED_BATCH_RECEIVE_POLICY = BatchReceivePolicy.builder().timeout(0, TimeUnit.MILLISECONDS).maxNumMessages(1).build();
    private final ConsumerImpl<T> consumer;

    public ReaderImpl(PulsarClientImpl client, ReaderConfigurationData<T> readerConfiguration, ExecutorProvider executorProvider, CompletableFuture<Consumer<T>> consumerFuture, Schema<T> schema) {
        String subscription;
        if (StringUtils.isNotBlank((CharSequence)readerConfiguration.getSubscriptionName())) {
            subscription = readerConfiguration.getSubscriptionName();
        } else {
            subscription = "reader-" + DigestUtils.sha1Hex((String)UUID.randomUUID().toString()).substring(0, 10);
            if (StringUtils.isNotBlank((CharSequence)readerConfiguration.getSubscriptionRolePrefix())) {
                subscription = readerConfiguration.getSubscriptionRolePrefix() + "-" + subscription;
            }
        }
        ConsumerConfigurationData consumerConfiguration = new ConsumerConfigurationData();
        consumerConfiguration.getTopicNames().add(readerConfiguration.getTopicName());
        consumerConfiguration.setSubscriptionName(subscription);
        consumerConfiguration.setSubscriptionType(SubscriptionType.Exclusive);
        consumerConfiguration.setSubscriptionMode(SubscriptionMode.NonDurable);
        consumerConfiguration.setReceiverQueueSize(readerConfiguration.getReceiverQueueSize());
        consumerConfiguration.setReadCompacted(readerConfiguration.isReadCompacted());
        consumerConfiguration.setBatchReceivePolicy(DISABLED_BATCH_RECEIVE_POLICY);
        if (readerConfiguration.getReaderName() != null) {
            consumerConfiguration.setConsumerName(readerConfiguration.getReaderName());
        }
        if (readerConfiguration.isResetIncludeHead()) {
            consumerConfiguration.setResetIncludeHead(true);
        }
        if (readerConfiguration.getReaderListener() != null) {
            final ReaderListener<T> readerListener = readerConfiguration.getReaderListener();
            consumerConfiguration.setMessageListener(new MessageListener<T>(){
                private static final long serialVersionUID = 1L;

                public void received(Consumer<T> consumer, Message<T> msg) {
                    readerListener.received((Reader)ReaderImpl.this, msg);
                    consumer.acknowledgeCumulativeAsync(msg);
                }

                public void reachedEndOfTopic(Consumer<T> consumer) {
                    readerListener.reachedEndOfTopic((Reader)ReaderImpl.this);
                }
            });
        }
        consumerConfiguration.setCryptoFailureAction(readerConfiguration.getCryptoFailureAction());
        if (readerConfiguration.getCryptoKeyReader() != null) {
            consumerConfiguration.setCryptoKeyReader(readerConfiguration.getCryptoKeyReader());
        }
        if (readerConfiguration.getKeyHashRanges() != null) {
            consumerConfiguration.setKeySharedPolicy((KeySharedPolicy)KeySharedPolicy.stickyHashRange().ranges(readerConfiguration.getKeyHashRanges()));
        }
        int partitionIdx = TopicName.getPartitionIndex((String)readerConfiguration.getTopicName());
        this.consumer = new ConsumerImpl(client, readerConfiguration.getTopicName(), consumerConfiguration, executorProvider, partitionIdx, false, consumerFuture, readerConfiguration.getStartMessageId(), readerConfiguration.getStartMessageFromRollbackDurationInSec(), schema, null, true);
    }

    public String getTopic() {
        return this.consumer.getTopic();
    }

    public ConsumerImpl<T> getConsumer() {
        return this.consumer;
    }

    public boolean hasReachedEndOfTopic() {
        return this.consumer.hasReachedEndOfTopic();
    }

    public Message<T> readNext() throws PulsarClientException {
        Message msg = this.consumer.receive();
        this.consumer.acknowledgeCumulativeAsync(msg);
        return msg;
    }

    public Message<T> readNext(int timeout, TimeUnit unit) throws PulsarClientException {
        Message msg = this.consumer.receive(timeout, unit);
        if (msg != null) {
            this.consumer.acknowledgeCumulativeAsync(msg);
        }
        return msg;
    }

    public CompletableFuture<Message<T>> readNextAsync() {
        CompletableFuture receiveFuture = this.consumer.receiveAsync();
        receiveFuture.whenComplete((msg, t) -> {
            if (msg != null) {
                this.consumer.acknowledgeCumulativeAsync((Message<?>)msg);
            }
        });
        return receiveFuture;
    }

    public void close() throws IOException {
        this.consumer.close();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.consumer.closeAsync();
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        return this.consumer.hasMessageAvailable();
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        return this.consumer.hasMessageAvailableAsync();
    }

    public boolean isConnected() {
        return this.consumer.isConnected();
    }

    public void seek(MessageId messageId) throws PulsarClientException {
        this.consumer.seek(messageId);
    }

    public void seek(long timestamp) throws PulsarClientException {
        this.consumer.seek(timestamp);
    }

    public void seek(Function<String, Object> function) throws PulsarClientException {
        this.consumer.seek(function);
    }

    public CompletableFuture<Void> seekAsync(Function<String, Object> function) {
        return this.consumer.seekAsync(function);
    }

    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        return this.consumer.seekAsync(messageId);
    }

    public CompletableFuture<Void> seekAsync(long timestamp) {
        return this.consumer.seekAsync(timestamp);
    }
}

