/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.util.Objects;
import java.util.Optional;

public final class ConfigurationBinding<T> {
    private final Key<T> key;
    private final Class<T> configClass;
    private final Optional<String> prefix;

    public ConfigurationBinding(Key<T> key, Class<T> configClass, Optional<String> prefix) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(configClass, "configClass");
        Objects.requireNonNull(prefix, "prefix is null");
        Preconditions.checkArgument((!prefix.isPresent() || !prefix.get().isEmpty() ? 1 : 0) != 0, (Object)"prefix is empty");
        this.key = key;
        this.configClass = configClass;
        this.prefix = prefix;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public Optional<String> getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationBinding that = (ConfigurationBinding)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", this.configClass).add("qualifier", Optional.ofNullable(this.key.getAnnotationType()).map(Class::getSimpleName).orElse(null)).add("prefix", this.prefix.orElse(null)).toString();
    }
}

