/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spiller;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spiller.SpillCipher;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

final class AesSpillCipher
implements SpillCipher {
    private static final String CIPHER_NAME = "AES/CBC/PKCS5Padding";
    private static final int KEY_BITS = 256;
    private SecretKey key = AesSpillCipher.generateNewSecretKey();
    private Cipher encryptSizer = AesSpillCipher.createEncryptCipher(this.key);
    private final int ivBytes = this.encryptSizer.getIV().length;

    AesSpillCipher() {
    }

    @Override
    public int encryptedMaxLength(int inputLength) {
        Preconditions.checkArgument((inputLength >= 0 ? 1 : 0) != 0, (String)"inputLength must be >= 0, inputLength=%s", (int)inputLength);
        Cipher sizer = AesSpillCipher.throwCipherClosedIfNull(this.encryptSizer);
        return this.ivBytes + sizer.getOutputSize(inputLength);
    }

    @Override
    public int decryptedMaxLength(int encryptedLength) {
        Preconditions.checkArgument((encryptedLength >= this.ivBytes ? 1 : 0) != 0, (String)"encryptedLength must be >= %s", (int)this.ivBytes);
        return encryptedLength - this.ivBytes;
    }

    @Override
    public int encrypt(byte[] data, int inputOffset, int length, byte[] destination, int destinationOffset) {
        Preconditions.checkArgument((data.length - inputOffset >= length ? 1 : 0) != 0, (Object)"data buffer too small for length argument");
        Preconditions.checkArgument((destination.length - destinationOffset >= this.encryptedMaxLength(length) ? 1 : 0) != 0, (Object)"destination buffer too small for encrypted output");
        Cipher cipher = AesSpillCipher.createEncryptCipher(this.key);
        System.arraycopy(cipher.getIV(), 0, destination, destinationOffset, this.ivBytes);
        try {
            return this.ivBytes + cipher.doFinal(data, inputOffset, length, destination, destinationOffset + this.ivBytes);
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to encrypt data: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int decrypt(byte[] encryptedData, int inputOffset, int length, byte[] destination, int destinationOffset) {
        Preconditions.checkArgument((encryptedData.length - inputOffset >= length ? 1 : 0) != 0, (Object)"encryptedData too small for length argument");
        Preconditions.checkArgument((destination.length - destinationOffset >= this.decryptedMaxLength(length) ? 1 : 0) != 0, (Object)"destination buffer too small for decrypted output");
        Cipher cipher = AesSpillCipher.createDecryptCipher(this.key, new IvParameterSpec(encryptedData, inputOffset, this.ivBytes));
        try {
            return cipher.doFinal(encryptedData, inputOffset + this.ivBytes, length - this.ivBytes, destination, destinationOffset);
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Cannot decrypt previously encrypted data: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.key = null;
        this.encryptSizer = null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("closed", this.key == null).toString();
    }

    private static <T> T throwCipherClosedIfNull(T value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Spill cipher already closed");
        }
        return value;
    }

    private static Cipher createEncryptCipher(SecretKey key) {
        Cipher cipher = AesSpillCipher.createUninitializedCipher();
        try {
            cipher.init(1, AesSpillCipher.throwCipherClosedIfNull(key));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to initialize spill cipher for encryption: " + e.getMessage(), (Throwable)e);
        }
    }

    private static Cipher createDecryptCipher(SecretKey key, IvParameterSpec iv) {
        Cipher cipher = AesSpillCipher.createUninitializedCipher();
        try {
            cipher.init(2, (Key)AesSpillCipher.throwCipherClosedIfNull(key), iv);
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to initialize spill cipher for decryption: " + e.getMessage(), (Throwable)e);
        }
    }

    private static Cipher createUninitializedCipher() {
        try {
            return Cipher.getInstance(CIPHER_NAME);
        }
        catch (GeneralSecurityException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create spill cipher: " + e.getMessage(), (Throwable)e);
        }
    }

    private static SecretKey generateNewSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to generate new secret key: " + e.getMessage(), (Throwable)e);
        }
    }
}

