/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import java.util.function.Function;
import org.weakref.jmx.ObjectNameGenerator;
import org.weakref.jmx.guice.Mapping;

public class NamedExportBinder {
    protected final Multibinder<Mapping> binder;
    protected final Key<?> key;

    NamedExportBinder(Multibinder<Mapping> binder, Key<?> key) {
        this.binder = binder;
        this.key = key;
    }

    public void withGeneratedName() {
        if (this.key.getAnnotation() != null) {
            if (this.key.getAnnotation() instanceof Named) {
                this.as((ObjectNameGenerator factory) -> factory.generatedNameOf(this.key.getTypeLiteral().getRawType(), ((Named)this.key.getAnnotation()).value()));
            } else {
                this.as((ObjectNameGenerator factory) -> factory.generatedNameOf(this.key.getTypeLiteral().getRawType(), this.key.getAnnotation().annotationType().getSimpleName()));
            }
        } else if (this.key.getAnnotationType() != null) {
            this.as((ObjectNameGenerator factory) -> factory.generatedNameOf(this.key.getTypeLiteral().getRawType(), this.key.getAnnotationType().getSimpleName()));
        } else {
            this.as((ObjectNameGenerator factory) -> factory.generatedNameOf(this.key.getTypeLiteral().getRawType()));
        }
    }

    public void as(String name) {
        this.as((ObjectNameGenerator factory) -> name);
    }

    public void as(Function<ObjectNameGenerator, String> nameFactory) {
        this.binder.addBinding().toInstance((Object)new Mapping(nameFactory, this.key));
    }
}

