/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.util.concurrent.Scheduler;

public final class DelegatingScheduler
implements Scheduler {
    public static final DelegatingScheduler INSTANCE = new DelegatingScheduler();
    private static final ExecutorService COMMON_POOL = ForkJoinPool.commonPool();
    private static volatile ScheduledExecutorService delayer;
    private final ExecutorService executorService;

    private DelegatingScheduler() {
        this.executorService = null;
    }

    public DelegatingScheduler(ExecutorService executor) {
        this.executorService = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScheduledExecutorService delayer() {
        if (delayer != null) return delayer;
        Class<DelegatingScheduler> clazz = DelegatingScheduler.class;
        synchronized (DelegatingScheduler.class) {
            if (delayer != null) return delayer;
            delayer = new ScheduledThreadPoolExecutor(1, new DelayerThreadFactory());
            // ** MonitorExit[var0] (shouldn't be in output)
            return delayer;
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Callable<?> callable, long delay, TimeUnit unit) {
        ScheduledCompletableFuture promise = new ScheduledCompletableFuture(delay, unit);
        ExecutorService es = this.executorService != null ? this.executorService : COMMON_POOL;
        boolean isForkJoinPool = es instanceof ForkJoinPool;
        Callable<Object> completingCallable = () -> {
            try {
                if (isForkJoinPool) {
                    ScheduledCompletableFuture scheduledCompletableFuture = promise;
                    synchronized (scheduledCompletableFuture) {
                        promise.forkJoinPoolThread = Thread.currentThread();
                    }
                }
                promise.complete(callable.call());
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return null;
        };
        promise.delegate = delay == 0L ? es.submit(completingCallable) : DelegatingScheduler.delayer().schedule(() -> {
            ScheduledCompletableFuture scheduledCompletableFuture = promise;
            synchronized (scheduledCompletableFuture) {
                if (!promise.isCancelled()) {
                    promise.delegate = es.submit(completingCallable);
                }
            }
        }, delay, unit);
        return promise;
    }

    static final class ScheduledCompletableFuture<V>
    extends CompletableFuture<V>
    implements ScheduledFuture<V> {
        volatile Future<V> delegate;
        volatile Thread forkJoinPoolThread;
        private final long time;

        ScheduledCompletableFuture(long delay, TimeUnit unit) {
            this.time = System.nanoTime() + unit.toNanos(delay);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledCompletableFuture) {
                return Long.compare(this.time, ((ScheduledCompletableFuture)other).time);
            }
            return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), other.getDelay(TimeUnit.NANOSECONDS));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = super.cancel(mayInterruptIfRunning);
            ScheduledCompletableFuture scheduledCompletableFuture = this;
            synchronized (scheduledCompletableFuture) {
                if (this.delegate != null) {
                    result = this.delegate.cancel(mayInterruptIfRunning);
                }
                if (this.forkJoinPoolThread != null) {
                    this.forkJoinPoolThread.interrupt();
                }
            }
            return result;
        }
    }

    static final class DelayerThreadFactory
    implements ThreadFactory {
        DelayerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("FailsafeDelayScheduler");
            return t;
        }
    }
}

