/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.Use;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;

public class UseTask
implements DataDefinitionTask<Use> {
    @Override
    public String getName() {
        return "USE";
    }

    @Override
    public ListenableFuture<?> execute(Use statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        String catalog;
        Session session = stateMachine.getSession();
        if (!metadata.getCatalogHandle(session, catalog = statement.getCatalog().map(identifier -> identifier.getValue().toLowerCase(Locale.ENGLISH)).orElseGet(() -> session.getCatalog().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, (Node)statement, "Catalog must be specified when session catalog is not set", new Object[0])))).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + catalog);
        }
        String schema = statement.getSchema().getValue().toLowerCase(Locale.ENGLISH);
        CatalogSchemaName name = new CatalogSchemaName(catalog, schema);
        if (!metadata.schemaExists(session, name)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema does not exist: " + name);
        }
        if (statement.getCatalog().isPresent()) {
            stateMachine.setSetCatalog(catalog);
        }
        stateMachine.setSetSchema(schema);
        return Futures.immediateFuture(null);
    }
}

