/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.decoder.raw;

import com.google.common.collect.ImmutableMap;
import io.prestosql.decoder.DecoderColumnHandle;
import io.prestosql.decoder.FieldValueProvider;
import io.prestosql.decoder.RowDecoder;
import io.prestosql.decoder.raw.RawColumnDecoder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class RawRowDecoder
implements RowDecoder {
    public static final String NAME = "raw";
    private final Map<DecoderColumnHandle, RawColumnDecoder> columnDecoders;

    public RawRowDecoder(Set<DecoderColumnHandle> columnHandles) {
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.columnDecoders = (Map)columnHandles.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this::createColumnDecoder));
    }

    private RawColumnDecoder createColumnDecoder(DecoderColumnHandle columnHandle) {
        return new RawColumnDecoder(columnHandle);
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data, Map<String, String> dataMap) {
        return Optional.of(this.columnDecoders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((RawColumnDecoder)entry.getValue()).decodeField(data))));
    }
}

