/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.QualifiedName;
import java.util.Objects;

public class ImplementBernoulliSampleAsFilter
implements Rule<SampleNode> {
    private static final Pattern<SampleNode> PATTERN = Patterns.sample().with(Patterns.Sample.sampleType().equalTo((Object)SampleNode.Type.BERNOULLI));
    private final Metadata metadata;

    public ImplementBernoulliSampleAsFilter(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SampleNode sample, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new FilterNode(sample.getId(), sample.getSource(), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"rand")).build(), (Expression)new DoubleLiteral(Double.toString(sample.getSampleRatio())))));
    }
}

