/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.InterpretedFunctionInvoker;
import java.util.Collections;
import java.util.OptionalDouble;

final class StatsUtil {
    private StatsUtil() {
    }

    static OptionalDouble toStatsRepresentation(Metadata metadata, Session session, Type type, Object value) {
        if (StatsUtil.convertibleToDoubleWithCast(type)) {
            InterpretedFunctionInvoker functionInvoker = new InterpretedFunctionInvoker(metadata);
            ResolvedFunction castFunction = metadata.getCoercion(type, (Type)DoubleType.DOUBLE);
            return OptionalDouble.of((Double)functionInvoker.invoke(castFunction, session.toConnectorSession(), Collections.singletonList(value)));
        }
        if (DateType.DATE.equals((Object)type)) {
            return OptionalDouble.of(((Long)value).doubleValue());
        }
        return OptionalDouble.empty();
    }

    private static boolean convertibleToDoubleWithCast(Type type) {
        return type instanceof DecimalType || type instanceof DoubleType || type instanceof RealType || type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType || type instanceof BooleanType;
    }
}

