/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.analyzer.RelationId;
import io.prestosql.sql.analyzer.RelationType;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.ParameterRewriter;
import io.prestosql.sql.planner.PlanBuilder;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.QueryPlanner;
import io.prestosql.sql.planner.RelationPlan;
import io.prestosql.sql.planner.SubqueryPlanner;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.TranslationMap;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.ExceptNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.AliasedRelation;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DefaultTraversalVisitor;
import io.prestosql.sql.tree.Except;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.Intersect;
import io.prestosql.sql.tree.Join;
import io.prestosql.sql.tree.JoinCriteria;
import io.prestosql.sql.tree.JoinUsing;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.Lateral;
import io.prestosql.sql.tree.NaturalJoin;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.QuerySpecification;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SampledRelation;
import io.prestosql.sql.tree.SetOperation;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.Table;
import io.prestosql.sql.tree.TableSubquery;
import io.prestosql.sql.tree.Union;
import io.prestosql.sql.tree.Unnest;
import io.prestosql.sql.tree.Values;
import io.prestosql.type.TypeCoercion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class RelationPlanner
extends DefaultTraversalVisitor<RelationPlan, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final Metadata metadata;
    private final TypeCoercion typeCoercion;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;

    RelationPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.metadata = metadata;
        this.typeCoercion = new TypeCoercion(metadata::getType);
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, lambdaDeclarationToSymbolMap, metadata, session);
    }

    protected RelationPlan visitTable(Table node, Void context) {
        Query namedQuery = this.analysis.getNamedQuery(node);
        Scope scope = this.analysis.getScope((Node)node);
        if (namedQuery != null) {
            RelationPlan subPlan = (RelationPlan)this.process((Node)namedQuery, null);
            Type[] types = (Type[])scope.getRelationType().getAllFields().stream().map(Field::getType).toArray(Type[]::new);
            RelationPlan withCoercions = this.addCoercions(subPlan, types);
            return new RelationPlan(withCoercions.getRoot(), scope, withCoercions.getFieldMappings());
        }
        TableHandle handle = this.analysis.getTableHandle(node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (Field field : scope.getRelationType().getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbolsBuilder.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
        }
        ImmutableList outputSymbols = outputSymbolsBuilder.build();
        TableScanNode root = TableScanNode.newInstance(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols, (Map<Symbol, ColumnHandle>)columns.build());
        RelationPlan tableScan = new RelationPlan(root, scope, (List<Symbol>)outputSymbols);
        tableScan = this.addRowFilters(node, tableScan);
        tableScan = this.addColumnMasks(node, tableScan);
        return tableScan;
    }

    private RelationPlan addRowFilters(Table node, RelationPlan plan) {
        PlanBuilder planBuilder = this.initializePlanBuilder(plan);
        for (Expression filter : this.analysis.getRowFilters(node)) {
            planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, filter, (Node)filter);
            planBuilder = planBuilder.withNewRoot(new FilterNode(this.idAllocator.getNextId(), planBuilder.getRoot(), planBuilder.rewrite(filter)));
        }
        return new RelationPlan(planBuilder.getRoot(), plan.getScope(), plan.getFieldMappings());
    }

    private RelationPlan addColumnMasks(Table table, RelationPlan plan) {
        Map<String, List<Expression>> columnMasks = this.analysis.getColumnMasks(table);
        PlanNode root = plan.getRoot();
        List<Symbol> mappings = plan.getFieldMappings();
        TranslationMap translations = new TranslationMap(plan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(mappings);
        PlanBuilder planBuilder = new PlanBuilder(translations, root);
        for (int i = 0; i < plan.getDescriptor().getAllFieldCount(); ++i) {
            Field field = plan.getDescriptor().getFieldByIndex(i);
            for (Expression mask : columnMasks.getOrDefault(field.getName().get(), (List<Expression>)ImmutableList.of())) {
                planBuilder = this.subqueryPlanner.handleSubqueries(planBuilder, mask, (Node)mask);
                LinkedHashMap<Symbol, Expression> assignments = new LinkedHashMap<Symbol, Expression>();
                for (Symbol symbol : root.getOutputSymbols()) {
                    assignments.put(symbol, (Expression)symbol.toSymbolReference());
                }
                assignments.put(mappings.get(i), translations.rewrite(mask));
                planBuilder = planBuilder.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), planBuilder.getRoot(), Assignments.copyOf(assignments)));
            }
        }
        return new RelationPlan(planBuilder.getRoot(), plan.getScope(), mappings);
    }

    protected RelationPlan visitAliasedRelation(AliasedRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        PlanNode root = subPlan.getRoot();
        ImmutableList mappings = subPlan.getFieldMappings();
        if (node.getColumnNames() != null) {
            ImmutableList.Builder newMappings = ImmutableList.builder();
            Assignments.Builder assignments = Assignments.builder();
            for (int i = 0; i < subPlan.getDescriptor().getAllFieldCount(); ++i) {
                Field field = subPlan.getDescriptor().getFieldByIndex(i);
                if (field.isHidden()) continue;
                Symbol aliasedColumn = this.symbolAllocator.newSymbol(field);
                assignments.put(aliasedColumn, (Expression)subPlan.getFieldMappings().get(i).toSymbolReference());
                newMappings.add((Object)aliasedColumn);
            }
            root = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build());
            mappings = newMappings.build();
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)mappings);
    }

    protected RelationPlan visitSampledRelation(SampledRelation node, Void context) {
        RelationPlan subPlan = (RelationPlan)this.process((Node)node.getRelation(), context);
        double ratio = this.analysis.getSampleRatio(node);
        SampleNode planNode = new SampleNode(this.idAllocator.getNextId(), subPlan.getRoot(), ratio, SampleNode.Type.fromType(node.getType()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), subPlan.getFieldMappings());
    }

    protected RelationPlan visitJoin(Join node, Void context) {
        ArrayList<Expression> postInnerJoinConditions;
        ArrayList<Expression> complexJoinExpressions;
        ImmutableList.Builder equiClauses;
        ImmutableList outputSymbols;
        PlanBuilder rightPlanBuilder;
        PlanBuilder leftPlanBuilder;
        block21: {
            RelationPlan leftPlan = (RelationPlan)this.process((Node)node.getLeft(), context);
            Optional<Unnest> unnest = this.getUnnest(node.getRight());
            if (unnest.isPresent()) {
                return this.planJoinUnnest(leftPlan, node, unnest.get());
            }
            Optional<Lateral> lateral = this.getLateral(node.getRight());
            if (lateral.isPresent()) {
                return this.planCorrelatedJoin(node, leftPlan, lateral.get());
            }
            RelationPlan rightPlan = (RelationPlan)this.process((Node)node.getRight(), context);
            if (node.getCriteria().isPresent() && node.getCriteria().get() instanceof JoinUsing) {
                return this.planJoinUsing(node, leftPlan, rightPlan);
            }
            leftPlanBuilder = this.initializePlanBuilder(leftPlan);
            rightPlanBuilder = this.initializePlanBuilder(rightPlan);
            outputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
            equiClauses = ImmutableList.builder();
            complexJoinExpressions = new ArrayList<Expression>();
            postInnerJoinConditions = new ArrayList<Expression>();
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) break block21;
            Expression criteria = this.analysis.getJoinCriteria(node);
            RelationType left = this.analysis.getOutputDescriptor((Node)node.getLeft());
            RelationType right = this.analysis.getOutputDescriptor((Node)node.getRight());
            ArrayList<Expression> leftComparisonExpressions = new ArrayList<Expression>();
            ArrayList<Expression> rightComparisonExpressions = new ArrayList<Expression>();
            ArrayList<ComparisonExpression.Operator> joinConditionComparisonOperators = new ArrayList<ComparisonExpression.Operator>();
            for (Expression conjunct : ExpressionUtils.extractConjuncts(criteria)) {
                block23: {
                    block22: {
                        if (!RelationPlanner.isEqualComparisonExpression(conjunct = ExpressionUtils.normalize(conjunct)) && node.getType() != Join.Type.INNER) {
                            complexJoinExpressions.add(conjunct);
                            continue;
                        }
                        Set<QualifiedName> dependencies = SymbolsExtractor.extractNames(conjunct, this.analysis.getColumnReferences());
                        if (dependencies.stream().allMatch(left::canResolve)) break block22;
                        if (!dependencies.stream().allMatch(right::canResolve)) break block23;
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                if (conjunct instanceof ComparisonExpression) {
                    Expression firstExpression = ((ComparisonExpression)conjunct).getLeft();
                    Expression secondExpression = ((ComparisonExpression)conjunct).getRight();
                    ComparisonExpression.Operator comparisonOperator = ((ComparisonExpression)conjunct).getOperator();
                    Set<QualifiedName> firstDependencies = SymbolsExtractor.extractNames(firstExpression, this.analysis.getColumnReferences());
                    Set<QualifiedName> secondDependencies = SymbolsExtractor.extractNames(secondExpression, this.analysis.getColumnReferences());
                    if (firstDependencies.stream().allMatch(left::canResolve)) {
                        if (secondDependencies.stream().allMatch(right::canResolve)) {
                            leftComparisonExpressions.add(firstExpression);
                            rightComparisonExpressions.add(secondExpression);
                            joinConditionComparisonOperators.add(comparisonOperator);
                            continue;
                        }
                    }
                    if (firstDependencies.stream().allMatch(right::canResolve)) {
                        if (secondDependencies.stream().allMatch(left::canResolve)) {
                            leftComparisonExpressions.add(secondExpression);
                            rightComparisonExpressions.add(firstExpression);
                            joinConditionComparisonOperators.add(comparisonOperator.flip());
                            continue;
                        }
                    }
                    complexJoinExpressions.add(conjunct);
                    continue;
                }
                complexJoinExpressions.add(conjunct);
            }
            leftPlanBuilder = this.subqueryPlanner.handleSubqueries(leftPlanBuilder, leftComparisonExpressions, (Node)node);
            rightPlanBuilder = this.subqueryPlanner.handleSubqueries(rightPlanBuilder, rightComparisonExpressions, (Node)node);
            leftPlanBuilder = leftPlanBuilder.appendProjections(leftComparisonExpressions, this.symbolAllocator, this.idAllocator);
            rightPlanBuilder = rightPlanBuilder.appendProjections(rightComparisonExpressions, this.symbolAllocator, this.idAllocator);
            for (int i = 0; i < leftComparisonExpressions.size(); ++i) {
                if (joinConditionComparisonOperators.get(i) == ComparisonExpression.Operator.EQUAL) {
                    Symbol leftSymbol = leftPlanBuilder.translate((Expression)leftComparisonExpressions.get(i));
                    Symbol rightSymbol = rightPlanBuilder.translate((Expression)rightComparisonExpressions.get(i));
                    equiClauses.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                    continue;
                }
                Expression leftExpression = leftPlanBuilder.rewrite((Expression)leftComparisonExpressions.get(i));
                Expression rightExpression = rightPlanBuilder.rewrite((Expression)rightComparisonExpressions.get(i));
                postInnerJoinConditions.add((Expression)new ComparisonExpression((ComparisonExpression.Operator)joinConditionComparisonOperators.get(i), leftExpression, rightExpression));
            }
        }
        PlanNode root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, Symbol>)ImmutableMap.of(), Optional.empty());
        if (node.getType() != Join.Type.INNER) {
            for (Expression complexExpression : complexJoinExpressions) {
                Set<InPredicate> inPredicates = this.subqueryPlanner.collectInPredicateSubqueries(complexExpression, (Node)node);
                if (inPredicates.isEmpty()) continue;
                InPredicate inPredicate = (InPredicate)Iterables.getLast(inPredicates);
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)inPredicate, "IN with subquery predicate in join condition is not supported", new Object[0]);
            }
            leftPlanBuilder = this.subqueryPlanner.handleUncorrelatedSubqueries(leftPlanBuilder, complexJoinExpressions, (Node)node);
        }
        TranslationMap translationMap = this.translationMapFromSourceOutputs((List<Symbol>)ImmutableList.builder().addAll(leftPlanBuilder.getRoot().getOutputSymbols()).addAll(rightPlanBuilder.getRoot().getOutputSymbols()).build(), (Node)node, (List<Symbol>)outputSymbols);
        translationMap.setFieldMappings((List<Symbol>)outputSymbols);
        translationMap.putExpressionMappingsFrom(leftPlanBuilder.getTranslations());
        translationMap.putExpressionMappingsFrom(rightPlanBuilder.getTranslations());
        if (node.getType() != Join.Type.INNER && !complexJoinExpressions.isEmpty()) {
            Expression joinedFilterCondition = ExpressionUtils.and(complexJoinExpressions);
            Expression rewrittenFilterCondition = translationMap.rewrite(joinedFilterCondition);
            root = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftPlanBuilder.getRoot(), rightPlanBuilder.getRoot(), (List<JoinNode.EquiJoinClause>)equiClauses.build(), leftPlanBuilder.getRoot().getOutputSymbols(), rightPlanBuilder.getRoot().getOutputSymbols(), Optional.of(rewrittenFilterCondition), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, Symbol>)ImmutableMap.of(), Optional.empty());
        }
        if (node.getType() == Join.Type.INNER) {
            PlanBuilder rootPlanBuilder = new PlanBuilder(translationMap, root);
            rootPlanBuilder = this.subqueryPlanner.handleSubqueries(rootPlanBuilder, complexJoinExpressions, (Node)node);
            for (Expression expression : complexJoinExpressions) {
                postInnerJoinConditions.add(rootPlanBuilder.rewrite(expression));
            }
            root = rootPlanBuilder.getRoot();
            if (!postInnerJoinConditions.isEmpty()) {
                Expression postInnerJoinCriteria = ExpressionUtils.and(postInnerJoinConditions);
                root = new FilterNode(this.idAllocator.getNextId(), root, postInnerJoinCriteria);
            }
        }
        return new RelationPlan(root, this.analysis.getScope((Node)node), (List<Symbol>)outputSymbols);
    }

    private RelationPlan planJoinUsing(Join node, RelationPlan left, RelationPlan right) {
        Symbol symbol;
        List joinColumns = ((JoinUsing)node.getCriteria().get()).getColumns();
        Analysis.JoinUsingAnalysis joinAnalysis = this.analysis.getJoinUsing(node);
        ImmutableList.Builder clauses = ImmutableList.builder();
        HashMap<Identifier, Symbol> leftJoinColumns = new HashMap<Identifier, Symbol>();
        HashMap<Identifier, Symbol> rightJoinColumns = new HashMap<Identifier, Symbol>();
        Assignments.Builder leftCoercions = Assignments.builder();
        Assignments.Builder rightCoercions = Assignments.builder();
        leftCoercions.putIdentities(left.getRoot().getOutputSymbols());
        rightCoercions.putIdentities(right.getRoot().getOutputSymbols());
        for (int i = 0; i < joinColumns.size(); ++i) {
            Identifier identifier = (Identifier)joinColumns.get(i);
            Type type = this.analysis.getType((Expression)identifier);
            Symbol leftOutput = this.symbolAllocator.newSymbol((Expression)identifier, type);
            int leftField = joinAnalysis.getLeftJoinFields().get(i);
            leftCoercions.put(leftOutput, (Expression)new Cast((Expression)left.getSymbol(leftField).toSymbolReference(), TypeSignatureTranslator.toSqlType(type), false, this.typeCoercion.isTypeOnlyCoercion(left.getDescriptor().getFieldByIndex(leftField).getType(), type)));
            leftJoinColumns.put(identifier, leftOutput);
            Symbol rightOutput = this.symbolAllocator.newSymbol((Expression)identifier, type);
            int rightField = joinAnalysis.getRightJoinFields().get(i);
            rightCoercions.put(rightOutput, (Expression)new Cast((Expression)right.getSymbol(rightField).toSymbolReference(), TypeSignatureTranslator.toSqlType(type), false, this.typeCoercion.isTypeOnlyCoercion(right.getDescriptor().getFieldByIndex(rightField).getType(), type)));
            rightJoinColumns.put(identifier, rightOutput);
            clauses.add((Object)new JoinNode.EquiJoinClause(leftOutput, rightOutput));
        }
        ProjectNode leftCoercion = new ProjectNode(this.idAllocator.getNextId(), left.getRoot(), leftCoercions.build());
        ProjectNode rightCoercion = new ProjectNode(this.idAllocator.getNextId(), right.getRoot(), rightCoercions.build());
        JoinNode join = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.typeConvert(node.getType()), leftCoercion, rightCoercion, (List<JoinNode.EquiJoinClause>)clauses.build(), leftCoercion.getOutputSymbols(), rightCoercion.getOutputSymbols(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, Symbol>)ImmutableMap.of(), Optional.empty());
        Assignments.Builder assignments = Assignments.builder();
        ImmutableList.Builder outputs = ImmutableList.builder();
        for (Identifier column : joinColumns) {
            Symbol output = this.symbolAllocator.newSymbol((Expression)column, this.analysis.getType((Expression)column));
            outputs.add((Object)output);
            assignments.put(output, (Expression)new CoalesceExpression((Expression)((Symbol)leftJoinColumns.get(column)).toSymbolReference(), (Expression)((Symbol)rightJoinColumns.get(column)).toSymbolReference(), new Expression[0]));
        }
        Iterator<Object> iterator = joinAnalysis.getOtherLeftFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = left.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.put(symbol, (Expression)symbol.toSymbolReference());
        }
        iterator = joinAnalysis.getOtherRightFields().iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            symbol = right.getFieldMappings().get(field);
            outputs.add((Object)symbol);
            assignments.put(symbol, (Expression)symbol.toSymbolReference());
        }
        return new RelationPlan(new ProjectNode(this.idAllocator.getNextId(), join, assignments.build()), this.analysis.getScope((Node)node), (List<Symbol>)outputs.build());
    }

    private Optional<Unnest> getUnnest(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getUnnest(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Unnest) {
            return Optional.of((Unnest)relation);
        }
        return Optional.empty();
    }

    private Optional<Lateral> getLateral(Relation relation) {
        if (relation instanceof AliasedRelation) {
            return this.getLateral(((AliasedRelation)relation).getRelation());
        }
        if (relation instanceof Lateral) {
            return Optional.of((Lateral)relation);
        }
        return Optional.empty();
    }

    private RelationPlan planCorrelatedJoin(Join join, RelationPlan leftPlan, Lateral lateral) {
        BooleanLiteral filterExpression;
        RelationPlan rightPlan = (RelationPlan)this.process((Node)lateral.getQuery(), null);
        PlanBuilder leftPlanBuilder = this.initializePlanBuilder(leftPlan);
        PlanBuilder rightPlanBuilder = this.initializePlanBuilder(rightPlan);
        if (!join.getCriteria().isPresent()) {
            filterExpression = BooleanLiteral.TRUE_LITERAL;
        } else {
            JoinCriteria criteria = (JoinCriteria)join.getCriteria().get();
            if (criteria instanceof JoinUsing || criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)join, "Correlated join with criteria other than ON is not supported", new Object[0]);
            }
            filterExpression = (Expression)Iterables.getOnlyElement((Iterable)criteria.getNodes());
        }
        ImmutableList rewriterOutputSymbols = ImmutableList.builder().addAll(leftPlan.getFieldMappings()).addAll(rightPlan.getFieldMappings()).build();
        TranslationMap translationMap = this.translationMapFromSourceOutputs((List<Symbol>)ImmutableList.builder().addAll(leftPlanBuilder.getRoot().getOutputSymbols()).addAll(rightPlanBuilder.getRoot().getOutputSymbols()).build(), (Node)join, (List<Symbol>)rewriterOutputSymbols);
        translationMap.setFieldMappings((List<Symbol>)rewriterOutputSymbols);
        translationMap.putExpressionMappingsFrom(leftPlanBuilder.getTranslations());
        translationMap.putExpressionMappingsFrom(rightPlanBuilder.getTranslations());
        Expression rewrittenFilterCondition = translationMap.rewrite((Expression)filterExpression);
        PlanBuilder planBuilder = this.subqueryPlanner.appendCorrelatedJoin(leftPlanBuilder, rightPlanBuilder, lateral.getQuery(), true, CorrelatedJoinNode.Type.typeConvert(join.getType()), rewrittenFilterCondition);
        ImmutableList outputSymbols = ImmutableList.builder().addAll(leftPlan.getRoot().getOutputSymbols()).addAll(rightPlan.getRoot().getOutputSymbols()).build();
        return new RelationPlan(planBuilder.getRoot(), this.analysis.getScope((Node)join), (List<Symbol>)outputSymbols);
    }

    private static boolean isEqualComparisonExpression(Expression conjunct) {
        return conjunct instanceof ComparisonExpression && ((ComparisonExpression)conjunct).getOperator() == ComparisonExpression.Operator.EQUAL;
    }

    private RelationPlan planJoinUnnest(RelationPlan leftPlan, Join joinNode, Unnest node) {
        RelationType unnestOutputDescriptor = this.analysis.getOutputDescriptor((Node)node);
        ImmutableList.Builder unnestedSymbolsBuilder = ImmutableList.builder();
        for (Field field : unnestOutputDescriptor.getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            unnestedSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = unnestedSymbolsBuilder.build();
        PlanBuilder planBuilder = this.initializePlanBuilder(leftPlan);
        planBuilder = planBuilder.appendProjections(node.getExpressions(), this.symbolAllocator, this.idAllocator);
        TranslationMap translations = planBuilder.getTranslations();
        ProjectNode projectNode = (ProjectNode)planBuilder.getRoot();
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        UnmodifiableIterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Symbol inputSymbol = translations.get(expression);
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (elementType instanceof RowType) {
                    ImmutableList.Builder unnestSymbolBuilder = ImmutableList.builder();
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestSymbolBuilder.add(unnestedSymbolsIterator.next());
                    }
                    unnestSymbols.put((Object)inputSymbol, (Object)unnestSymbolBuilder.build());
                    continue;
                }
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of((Object)unnestedSymbolsIterator.next(), (Object)unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        Optional<Expression> filterExpression = Optional.empty();
        if (joinNode.getCriteria().isPresent()) {
            JoinCriteria criteria = (JoinCriteria)joinNode.getCriteria().get();
            if (criteria instanceof NaturalJoin) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "Natural join involving UNNEST is not supported", new Object[0]);
            }
            if (criteria instanceof JoinUsing) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "USING for join involving UNNEST is not supported", new Object[0]);
            }
            Expression filter = (Expression)Iterables.getOnlyElement((Iterable)criteria.getNodes());
            if (filter.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                filterExpression = Optional.of(filter);
            } else {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)joinNode, "JOIN involving UNNEST on condition other than TRUE is not supported", new Object[0]);
            }
        }
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), projectNode, leftPlan.getFieldMappings(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol, JoinNode.Type.typeConvert(joinNode.getType()), filterExpression);
        return new RelationPlan(unnestNode, this.analysis.getScope((Node)joinNode), unnestNode.getOutputSymbols());
    }

    protected RelationPlan visitTableSubquery(TableSubquery node, Void context) {
        return (RelationPlan)this.process((Node)node.getQuery(), context);
    }

    protected RelationPlan visitQuery(Query node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).plan(node);
    }

    protected RelationPlan visitQuerySpecification(QuerySpecification node, Void context) {
        return new QueryPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).plan(node);
    }

    protected RelationPlan visitValues(Values node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList outputSymbols = outputSymbolsBuilder.build();
        TranslationMap translationMap = this.translationMapFromSourceOutputs((List<Symbol>)ImmutableList.of(), (Node)node, (List<Symbol>)outputSymbols);
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Expression row : node.getRows()) {
            ImmutableList.Builder values = ImmutableList.builder();
            if (row instanceof Row) {
                for (Expression item : ((Row)row).getItems()) {
                    Expression expression = translationMap.rewrite(item);
                    values.add((Object)ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis), (Expression)expression));
                }
            } else {
                Expression expression = translationMap.rewrite(row);
                values.add((Object)ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis), (Expression)expression));
            }
            rows.add((Object)values.build());
        }
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)outputSymbols, (List<List<Expression>>)rows.build());
        return new RelationPlan(valuesNode, scope, (List<Symbol>)outputSymbols);
    }

    protected RelationPlan visitUnnest(Unnest node, Void context) {
        Scope scope = this.analysis.getScope((Node)node);
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder();
        for (Field field : scope.getRelationType().getVisibleFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field);
            outputSymbolsBuilder.add((Object)symbol);
        }
        ImmutableList unnestedSymbols = outputSymbolsBuilder.build();
        TranslationMap translationMap = this.translationMapFromSourceOutputs((List<Symbol>)ImmutableList.of(), (Node)node, (List<Symbol>)unnestedSymbols);
        ImmutableList.Builder argumentSymbols = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableMap.Builder unnestSymbols = ImmutableMap.builder();
        Iterator unnestedSymbolsIterator = unnestedSymbols.iterator();
        for (Expression expression : node.getExpressions()) {
            Type type = this.analysis.getType(expression);
            Expression rewritten = translationMap.rewrite(expression);
            rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis), (Expression)rewritten);
            values.add((Object)rewritten);
            Symbol inputSymbol = this.symbolAllocator.newSymbol(rewritten, type);
            argumentSymbols.add((Object)inputSymbol);
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (elementType instanceof RowType) {
                    ImmutableList.Builder unnestSymbolBuilder = ImmutableList.builder();
                    for (int i = 0; i < ((RowType)elementType).getFields().size(); ++i) {
                        unnestSymbolBuilder.add(unnestedSymbolsIterator.next());
                    }
                    unnestSymbols.put((Object)inputSymbol, (Object)unnestSymbolBuilder.build());
                    continue;
                }
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next()));
                continue;
            }
            if (type instanceof MapType) {
                unnestSymbols.put((Object)inputSymbol, (Object)ImmutableList.of(unnestedSymbolsIterator.next(), unnestedSymbolsIterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for UNNEST: " + type);
        }
        Optional<Symbol> ordinalitySymbol = node.isWithOrdinality() ? Optional.of(unnestedSymbolsIterator.next()) : Optional.empty();
        Preconditions.checkState((!unnestedSymbolsIterator.hasNext() ? 1 : 0) != 0, (Object)"Not all output symbols were matched with input symbols");
        ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)argumentSymbols.build(), (List<List<Expression>>)ImmutableList.of((Object)values.build()));
        UnnestNode unnestNode = new UnnestNode(this.idAllocator.getNextId(), valuesNode, (List<Symbol>)ImmutableList.of(), (Map<Symbol, List<Symbol>>)unnestSymbols.build(), ordinalitySymbol, JoinNode.Type.INNER, Optional.empty());
        return new RelationPlan(unnestNode, scope, (List<Symbol>)unnestedSymbols);
    }

    private TranslationMap translationMapFromSourceOutputs(List<Symbol> sourceOutputs, Node node, List<Symbol> outputSymbols) {
        ValuesNode dummy = new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.copyOf((Collection)Objects.requireNonNull(sourceOutputs, "sourceOutputs is null")), (List<List<Expression>>)ImmutableList.of());
        RelationPlan dummyRelationPlan = new RelationPlan(dummy, this.analysis.getScope(node), outputSymbols);
        return new TranslationMap(dummyRelationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
    }

    private RelationPlan processAndCoerceIfNecessary(Relation node, Void context) {
        Type[] coerceToTypes = this.analysis.getRelationCoercion(node);
        RelationPlan plan = (RelationPlan)this.process((Node)node, context);
        if (coerceToTypes == null) {
            return plan;
        }
        return this.addCoercions(plan, coerceToTypes);
    }

    private RelationPlan addCoercions(RelationPlan plan, Type[] targetColumnTypes) {
        List<Symbol> oldSymbols = plan.getFieldMappings();
        RelationType oldDescriptor = plan.getDescriptor().withOnlyVisibleFields();
        Verify.verify((targetColumnTypes.length == oldSymbols.size() ? 1 : 0) != 0);
        ImmutableList.Builder newSymbols = new ImmutableList.Builder();
        Field[] newFields = new Field[targetColumnTypes.length];
        Assignments.Builder assignments = Assignments.builder();
        for (int i = 0; i < targetColumnTypes.length; ++i) {
            Symbol outputSymbol;
            Symbol inputSymbol = oldSymbols.get(i);
            Type outputType = targetColumnTypes[i];
            Type inputType = this.symbolAllocator.getTypes().get(inputSymbol);
            if (!outputType.equals(inputType)) {
                Cast cast = new Cast((Expression)inputSymbol.toSymbolReference(), TypeSignatureTranslator.toSqlType(outputType));
                outputSymbol = this.symbolAllocator.newSymbol((Expression)cast, outputType);
                assignments.put(outputSymbol, (Expression)cast);
                newSymbols.add((Object)outputSymbol);
            } else {
                SymbolReference symbolReference = inputSymbol.toSymbolReference();
                outputSymbol = this.symbolAllocator.newSymbol((Expression)symbolReference, outputType);
                assignments.put(outputSymbol, (Expression)symbolReference);
                newSymbols.add((Object)outputSymbol);
            }
            Field oldField = oldDescriptor.getFieldByIndex(i);
            newFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), targetColumnTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        return new RelationPlan(projectNode, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(newFields)).build(), (List<Symbol>)newSymbols.build());
    }

    protected RelationPlan visitUnion(Union node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for UNION");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        PlanNode planNode = new UnionNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        if (node.isDistinct()) {
            planNode = this.distinct(planNode);
        }
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), planNode.getOutputSymbols());
    }

    protected RelationPlan visitIntersect(Intersect node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for INTERSECT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        IntersectNode planNode = new IntersectNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols());
    }

    protected RelationPlan visitExcept(Except node, Void context) {
        Preconditions.checkArgument((!node.getRelations().isEmpty() ? 1 : 0) != 0, (Object)"No relations specified for EXCEPT");
        SetOperationPlan setOperationPlan = this.process((SetOperation)node);
        ExceptNode planNode = new ExceptNode(this.idAllocator.getNextId(), setOperationPlan.getSources(), setOperationPlan.getSymbolMapping(), (List<Symbol>)ImmutableList.copyOf((Collection)setOperationPlan.getSymbolMapping().keySet()));
        return new RelationPlan(planNode, this.analysis.getScope((Node)node), ((PlanNode)planNode).getOutputSymbols());
    }

    private SetOperationPlan process(SetOperation node) {
        List outputs = null;
        ImmutableList.Builder sources = ImmutableList.builder();
        ImmutableListMultimap.Builder symbolMapping = ImmutableListMultimap.builder();
        List subPlans = (List)node.getRelations().stream().map(relation -> this.processAndCoerceIfNecessary((Relation)relation, null)).collect(ImmutableList.toImmutableList());
        for (RelationPlan relationPlan : subPlans) {
            int fieldIndex;
            RelationType descriptor;
            List<Symbol> childOutputSymbols = relationPlan.getFieldMappings();
            if (outputs == null) {
                descriptor = relationPlan.getDescriptor();
                ImmutableList.Builder outputSymbolBuilder = ImmutableList.builder();
                for (Field field : descriptor.getVisibleFields()) {
                    fieldIndex = descriptor.indexOf(field);
                    Symbol symbol = childOutputSymbols.get(fieldIndex);
                    outputSymbolBuilder.add((Object)this.symbolAllocator.newSymbol(symbol.getName(), this.symbolAllocator.getTypes().get(symbol)));
                }
                outputs = outputSymbolBuilder.build();
            }
            Preconditions.checkArgument(((descriptor = relationPlan.getDescriptor()).getVisibleFieldCount() == outputs.size() ? 1 : 0) != 0, (String)"Expected relation to have %s symbols but has %s symbols", (int)descriptor.getVisibleFieldCount(), (int)outputs.size());
            int fieldId = 0;
            for (Field field : descriptor.getVisibleFields()) {
                fieldIndex = descriptor.indexOf(field);
                symbolMapping.put(outputs.get(fieldId), (Object)childOutputSymbols.get(fieldIndex));
                ++fieldId;
            }
            sources.add((Object)relationPlan.getRoot());
        }
        return new SetOperationPlan((List)sources.build(), (ListMultimap)symbolMapping.build());
    }

    private PlanBuilder initializePlanBuilder(RelationPlan relationPlan) {
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private PlanNode distinct(PlanNode node) {
        return new AggregationNode(this.idAllocator.getNextId(), node, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(node.getOutputSymbols()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
    }

    private static class SetOperationPlan {
        private final List<PlanNode> sources;
        private final ListMultimap<Symbol, Symbol> symbolMapping;

        private SetOperationPlan(List<PlanNode> sources, ListMultimap<Symbol, Symbol> symbolMapping) {
            this.sources = sources;
            this.symbolMapping = symbolMapping;
        }

        public List<PlanNode> getSources() {
            return this.sources;
        }

        public ListMultimap<Symbol, Symbol> getSymbolMapping() {
            return this.symbolMapping;
        }
    }
}

