/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.prestosql.execution.scheduler.FileBasedNetworkTopology;
import io.prestosql.execution.scheduler.FlatNetworkTopology;
import io.prestosql.execution.scheduler.NetworkTopology;
import io.prestosql.execution.scheduler.NodeSchedulerExporter;
import io.prestosql.execution.scheduler.NodeSelectorFactory;
import io.prestosql.execution.scheduler.TopologyAwareNodeSelectorConfig;
import io.prestosql.execution.scheduler.TopologyAwareNodeSelectorFactory;
import io.prestosql.execution.scheduler.TopologyFileConfig;
import org.weakref.jmx.guice.ExportBinder;

public class TopologyAwareNodeSelectorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(TopologyAwareNodeSelectorConfig.class);
        this.bindNetworkTopology();
        binder.bind(TopologyAwareNodeSelectorFactory.class).in(Scopes.SINGLETON);
        binder.bind(NodeSelectorFactory.class).to(TopologyAwareNodeSelectorFactory.class).in(Scopes.SINGLETON);
        binder.bind(NodeSchedulerExporter.class).in(Scopes.SINGLETON);
    }

    private void bindNetworkTopology() {
        this.install(ConditionalModule.installModuleIf(TopologyAwareNodeSelectorConfig.class, config -> config.getType() == TopologyAwareNodeSelectorConfig.TopologyType.FLAT, binder -> binder.bind(NetworkTopology.class).to(FlatNetworkTopology.class).in(Scopes.SINGLETON)));
        this.install(ConditionalModule.installModuleIf(TopologyAwareNodeSelectorConfig.class, config -> config.getType() == TopologyAwareNodeSelectorConfig.TopologyType.FILE, binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(TopologyFileConfig.class);
            binder.bind(NetworkTopology.class).to(FileBasedNetworkTopology.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(FileBasedNetworkTopology.class).withGeneratedName();
        }));
    }
}

