/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.connector.CatalogName;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.execution.ForQueryExecution;
import io.prestosql.execution.Input;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.MemoryTrackingRemoteTaskFactory;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.RemoteTaskFactory;
import io.prestosql.execution.StageId;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.scheduler.ExecutionPolicy;
import io.prestosql.execution.scheduler.NodeScheduler;
import io.prestosql.execution.scheduler.SplitSchedulerStats;
import io.prestosql.execution.scheduler.SqlQueryScheduler;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.failuredetector.FailureDetector;
import io.prestosql.memory.VersionedMemoryPoolId;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.ForScheduler;
import io.prestosql.security.AccessControl;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.protocol.Slug;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.split.SplitManager;
import io.prestosql.split.SplitSource;
import io.prestosql.sql.ParameterUtils;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.DistributedExecutionPlanner;
import io.prestosql.sql.planner.InputExtractor;
import io.prestosql.sql.planner.LogicalPlanner;
import io.prestosql.sql.planner.NodePartitioningManager;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.PlanFragmenter;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.PlanOptimizers;
import io.prestosql.sql.planner.StageExecutionPlan;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.tree.Explain;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;

@ThreadSafe
public class SqlQueryExecution
implements QueryExecution {
    private static final Logger log = Logger.get(SqlQueryExecution.class);
    private static final OutputBuffers.OutputBufferId OUTPUT_BUFFER_ID = new OutputBuffers.OutputBufferId(0);
    private final QueryStateMachine stateMachine;
    private final Slug slug;
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final SplitManager splitManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final NodeScheduler nodeScheduler;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final RemoteTaskFactory remoteTaskFactory;
    private final LocationFactory locationFactory;
    private final int scheduleSplitBatchSize;
    private final ExecutorService queryExecutor;
    private final ScheduledExecutorService schedulerExecutor;
    private final FailureDetector failureDetector;
    private final AtomicReference<SqlQueryScheduler> queryScheduler = new AtomicReference();
    private final AtomicReference<Plan> queryPlan = new AtomicReference();
    private final NodeTaskMap nodeTaskMap;
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final Analysis analysis;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;

    private SqlQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Slug slug, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, List<PlanOptimizer> planOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, LocationFactory locationFactory, int scheduleSplitBatchSize, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{stateMachine.getQueryId()});){
            this.slug = Objects.requireNonNull(slug, "slug is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.executionPolicy = Objects.requireNonNull(executionPolicy, "executionPolicy is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            Preconditions.checkArgument((scheduleSplitBatchSize > 0 ? 1 : 0) != 0, (Object)"scheduleSplitBatchSize must be greater than 0");
            this.scheduleSplitBatchSize = scheduleSplitBatchSize;
            this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
            this.analysis = this.analyze(preparedQuery, stateMachine, metadata, accessControl, sqlParser, queryExplainer, warningCollector);
            AtomicReference<SqlQueryScheduler> queryScheduler = this.queryScheduler;
            stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                SqlQueryScheduler scheduler = (SqlQueryScheduler)queryScheduler.get();
                if (scheduler != null) {
                    scheduler.abort();
                }
            });
            this.remoteTaskFactory = new MemoryTrackingRemoteTaskFactory(Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null"), stateMachine);
        }
    }

    private Analysis analyze(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, QueryExplainer queryExplainer, WarningCollector warningCollector) {
        stateMachine.beginAnalysis();
        Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        Analyzer analyzer = new Analyzer(stateMachine.getSession(), metadata, sqlParser, accessControl, Optional.of(queryExplainer), preparedQuery.getParameters(), ParameterUtils.parameterExtractor(preparedQuery.getStatement(), preparedQuery.getParameters()), warningCollector);
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        stateMachine.setUpdateType(analysis.getUpdateType());
        stateMachine.setReferencedTables(analysis.getReferencedTables());
        stateMachine.setRoutines(analysis.getRoutines());
        stateMachine.endAnalysis();
        return analysis;
    }

    @Override
    public Slug getSlug() {
        return this.slug;
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getUserMemoryReservation();
        }
        if (scheduler == null) {
            return DataSize.ofBytes((long)0L);
        }
        return DataSize.succinctBytes((long)scheduler.getUserMemoryReservation());
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalMemoryReservation();
        }
        if (scheduler == null) {
            return DataSize.ofBytes((long)0L);
        }
        return DataSize.succinctBytes((long)scheduler.getTotalMemoryReservation());
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalCpuTime();
        }
        if (scheduler == null) {
            return new Duration(0.0, TimeUnit.SECONDS);
        }
        return scheduler.getTotalCpuTime();
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.ofNullable(this.queryScheduler.get()).map(SqlQueryScheduler::getBasicStageStats)));
    }

    @Override
    public void start() {
        Throwable throwable;
        SetThreadName ignored;
        block24: {
            block25: {
                block26: {
                    block21: {
                        block22: {
                            block23: {
                                ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});
                                throwable = null;
                                if (this.stateMachine.transitionToPlanning()) break block21;
                                if (ignored == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            ignored.close();
                        }
                        return;
                    }
                    PlanRoot plan = this.planQuery();
                    this.planDistribution(plan);
                    if (this.stateMachine.transitionToStarting()) break block24;
                    if (ignored == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block25;
                }
                ignored.close();
            }
            return;
        }
        try {
            try {
                SqlQueryScheduler scheduler = this.queryScheduler.get();
                if (!this.stateMachine.isDone()) {
                    scheduler.start();
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.throwIfInstanceOf((Throwable)e, Error.class);
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    private PlanRoot planQuery() {
        try {
            return this.doPlanQuery();
        }
        catch (StackOverflowError e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
    }

    private PlanRoot doPlanQuery() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(this.stateMachine.getSession(), this.planOptimizers, idAllocator, this.metadata, new TypeAnalyzer(this.sqlParser, this.metadata), this.statsCalculator, this.costCalculator, this.stateMachine.getWarningCollector());
        Plan plan = logicalPlanner.plan(this.analysis);
        this.queryPlan.set(plan);
        List<Input> inputs = new InputExtractor(this.metadata, this.stateMachine.getSession()).extractInputs(plan.getRoot());
        this.stateMachine.setInputs(inputs);
        this.stateMachine.setOutput(this.analysis.getTarget());
        SubPlan fragmentedPlan = this.planFragmenter.createSubPlans(this.stateMachine.getSession(), plan, false, this.stateMachine.getWarningCollector());
        boolean explainAnalyze = this.analysis.getStatement() instanceof Explain && ((Explain)this.analysis.getStatement()).isAnalyze();
        return new PlanRoot(fragmentedPlan, !explainAnalyze);
    }

    private void planDistribution(PlanRoot plan) {
        DistributedExecutionPlanner distributedPlanner = new DistributedExecutionPlanner(this.splitManager, this.metadata);
        StageExecutionPlan outputStageExecutionPlan = distributedPlanner.plan(plan.getRoot(), this.stateMachine.getSession());
        this.stateMachine.addStateChangeListener(state -> {
            if (state.isDone()) {
                SqlQueryExecution.closeSplitSources(outputStageExecutionPlan);
            }
        });
        if (this.stateMachine.isDone()) {
            return;
        }
        this.stateMachine.setColumns(outputStageExecutionPlan.getFieldNames(), outputStageExecutionPlan.getFragment().getTypes());
        PartitioningHandle partitioningHandle = plan.getRoot().getFragment().getPartitioningScheme().getPartitioning().getHandle();
        OutputBuffers rootOutputBuffers = OutputBuffers.createInitialEmptyOutputBuffers(partitioningHandle).withBuffer(OUTPUT_BUFFER_ID, 0).withNoMoreBufferIds();
        SqlQueryScheduler scheduler = SqlQueryScheduler.createSqlQueryScheduler(this.stateMachine, this.locationFactory, outputStageExecutionPlan, this.nodePartitioningManager, this.nodeScheduler, this.remoteTaskFactory, this.stateMachine.getSession(), plan.isSummarizeTaskInfos(), this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, rootOutputBuffers, this.nodeTaskMap, this.executionPolicy, this.schedulerStats);
        this.queryScheduler.set(scheduler);
        if (this.stateMachine.isDone()) {
            scheduler.abort();
            this.queryScheduler.set(null);
        }
    }

    private static void closeSplitSources(StageExecutionPlan plan) {
        for (SplitSource source : plan.getSplitSources().values()) {
            try {
                source.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing split source");
            }
        }
        for (StageExecutionPlan stage : plan.getSubStages()) {
            SqlQueryExecution.closeSplitSources(stage);
        }
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            if (scheduler != null) {
                scheduler.cancelStage(stageId);
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.stateMachine.addOutputInfoListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            QueryInfo queryInfo = this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.buildQueryInfo(scheduler));
            return queryInfo;
        }
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    @Override
    public Plan getQueryPlan() {
        return this.queryPlan.get();
    }

    private QueryInfo buildQueryInfo(SqlQueryScheduler scheduler) {
        QueryInfo queryInfo;
        Optional<StageInfo> stageInfo = Optional.empty();
        if (scheduler != null) {
            stageInfo = Optional.ofNullable(scheduler.getStageInfo());
        }
        if ((queryInfo = this.stateMachine.updateQueryInfo(stageInfo)).isFinalQueryInfo()) {
            this.queryScheduler.set(null);
        }
        return queryInfo;
    }

    @Override
    public boolean shouldWaitForMinWorkers() {
        return this.shouldWaitForMinWorkers(this.analysis.getStatement());
    }

    private boolean shouldWaitForMinWorkers(Statement statement) {
        if (statement instanceof Query) {
            Collection<TableHandle> tables = this.analysis.getTables();
            return !tables.stream().map(TableHandle::getCatalogName).allMatch(CatalogName::isInternalSystemConnector);
        }
        return true;
    }

    public static class SqlQueryExecutionFactory
    implements QueryExecution.QueryExecutionFactory<QueryExecution> {
        private final SplitSchedulerStats schedulerStats;
        private final int scheduleSplitBatchSize;
        private final Metadata metadata;
        private final AccessControl accessControl;
        private final SqlParser sqlParser;
        private final SplitManager splitManager;
        private final NodePartitioningManager nodePartitioningManager;
        private final NodeScheduler nodeScheduler;
        private final List<PlanOptimizer> planOptimizers;
        private final PlanFragmenter planFragmenter;
        private final RemoteTaskFactory remoteTaskFactory;
        private final QueryExplainer queryExplainer;
        private final LocationFactory locationFactory;
        private final ExecutorService queryExecutor;
        private final ScheduledExecutorService schedulerExecutor;
        private final FailureDetector failureDetector;
        private final NodeTaskMap nodeTaskMap;
        private final Map<String, ExecutionPolicy> executionPolicies;
        private final StatsCalculator statsCalculator;
        private final CostCalculator costCalculator;

        @Inject
        SqlQueryExecutionFactory(QueryManagerConfig config, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, LocationFactory locationFactory, SplitManager splitManager, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, PlanOptimizers planOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, @ForQueryExecution ExecutorService queryExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, QueryExplainer queryExplainer, Map<String, ExecutionPolicy> executionPolicies, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator) {
            Objects.requireNonNull(config, "config is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.scheduleSplitBatchSize = config.getScheduleSplitBatchSize();
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
            this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.executionPolicies = Objects.requireNonNull(executionPolicies, "schedulerPolicies is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null").get();
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        }

        @Override
        public QueryExecution createQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Slug slug, WarningCollector warningCollector) {
            String executionPolicyName = SystemSessionProperties.getExecutionPolicy(stateMachine.getSession());
            ExecutionPolicy executionPolicy = this.executionPolicies.get(executionPolicyName);
            Preconditions.checkArgument((executionPolicy != null ? 1 : 0) != 0, (String)"No execution policy %s", (Object)executionPolicyName);
            return new SqlQueryExecution(preparedQuery, stateMachine, slug, this.metadata, this.accessControl, this.sqlParser, this.splitManager, this.nodePartitioningManager, this.nodeScheduler, this.planOptimizers, this.planFragmenter, this.remoteTaskFactory, this.locationFactory, this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, this.nodeTaskMap, this.queryExplainer, executionPolicy, this.schedulerStats, this.statsCalculator, this.costCalculator, warningCollector);
        }
    }

    private static class PlanRoot {
        private final SubPlan root;
        private final boolean summarizeTaskInfos;

        public PlanRoot(SubPlan root, boolean summarizeTaskInfos) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.summarizeTaskInfos = summarizeTaskInfos;
        }

        public SubPlan getRoot() {
            return this.root;
        }

        public boolean isSummarizeTaskInfos() {
            return this.summarizeTaskInfos;
        }
    }
}

