/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.spnego;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.airlift.http.client.spnego.SpnegoAuthentication;
import io.airlift.http.client.spnego.UriUtil;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;

public class SpnegoAuthenticationStore
implements AuthenticationStore {
    private static final int CACHE_SIZE = 10000;
    private static final Duration CACHE_EXPIRE_TIME = new Duration(5.0, TimeUnit.MINUTES);
    private static final int CONCURRENCY_LEVEL = 16;
    private final Cache<URI, Authentication.Result> results;
    private final SpnegoAuthentication authentication;

    public SpnegoAuthenticationStore(SpnegoAuthentication authentication) {
        Objects.requireNonNull(authentication, "authentication is null");
        this.authentication = authentication;
        this.results = CacheBuilder.newBuilder().concurrencyLevel(16).maximumSize(10000L).expireAfterWrite(CACHE_EXPIRE_TIME.roundTo(TimeUnit.MINUTES), TimeUnit.MINUTES).build();
    }

    public void addAuthentication(Authentication authentication) {
        throw new UnsupportedOperationException("addAuthentication is not supported");
    }

    public void removeAuthentication(Authentication authentication) {
        throw new UnsupportedOperationException("removeAuthentication is not supported");
    }

    public void clearAuthentications() {
    }

    public Authentication findAuthentication(String type, URI uri, String realm) {
        if (this.authentication.matches(type, uri, realm)) {
            return this.authentication;
        }
        return null;
    }

    public void addAuthenticationResult(Authentication.Result result) {
        this.results.put((Object)UriUtil.normalizedUri(result.getURI()), (Object)result);
    }

    public void removeAuthenticationResult(Authentication.Result result) {
        this.results.invalidate((Object)UriUtil.normalizedUri(result.getURI()));
    }

    public void clearAuthenticationResults() {
        this.results.invalidateAll();
    }

    public Authentication.Result findAuthenticationResult(URI uri) {
        Objects.requireNonNull(uri, "uri is null");
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            return (Authentication.Result)this.results.getIfPresent((Object)UriUtil.normalizedUri(uri));
        }
        return null;
    }
}

