/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.management.ObjectName;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNameGenerator;
import org.weakref.jmx.guice.MapMapping;
import org.weakref.jmx.guice.Mapping;
import org.weakref.jmx.guice.SetMapping;

class GuiceMBeanExporter {
    @Inject
    public GuiceMBeanExporter(Set<Mapping> mappings, Set<SetMapping<?>> setMappings, Set<MapMapping<?, ?>> mapMappings, MBeanExporter exporter, Optional<ObjectNameGenerator> objectNameGenerator, Injector injector) {
        ObjectNameGenerator generator = objectNameGenerator.orElseGet(ObjectNameGenerator::defaultObjectNameGenerator);
        GuiceMBeanExporter.export(mappings, exporter, injector, generator);
        GuiceMBeanExporter.exportSets(GuiceMBeanExporter.castSetMapping(setMappings), exporter, injector, generator);
        GuiceMBeanExporter.exportMaps(GuiceMBeanExporter.castMapMappings(mapMappings), exporter, injector, generator);
    }

    private static Set<MapMapping<Object, Object>> castMapMappings(Object mapMappings) {
        return (Set)mapMappings;
    }

    private static Set<SetMapping<Object>> castSetMapping(Object setMappings) {
        return (Set)setMappings;
    }

    private static <K, V> void exportMaps(Set<MapMapping<K, V>> mapMappings, MBeanExporter exporter, Injector injector, ObjectNameGenerator objectNameGenerator) {
        for (MapMapping<K, V> mapping : mapMappings) {
            BiFunction<ObjectNameGenerator, Map.Entry<K, V>, ObjectName> namingFunction = mapping.getObjectNameFunction();
            Map map = (Map)injector.getInstance(mapping.getKey());
            for (Map.Entry entry : map.entrySet()) {
                ObjectName name = namingFunction.apply(objectNameGenerator, entry);
                exporter.export(name, entry.getValue());
            }
        }
    }

    private static <T> void exportSets(Set<SetMapping<T>> setMappings, MBeanExporter exporter, Injector injector, ObjectNameGenerator objectNameGenerator) {
        for (SetMapping<T> mapping : setMappings) {
            BiFunction<ObjectNameGenerator, ObjectNameGenerator, ObjectName> namingFunction = mapping.getObjectNameFunction();
            Set set = (Set)injector.getInstance(mapping.getKey());
            for (Object instance : set) {
                ObjectName name = namingFunction.apply(objectNameGenerator, (ObjectNameGenerator)instance);
                exporter.export(name, instance);
            }
        }
    }

    private static void export(Set<Mapping> mappings, MBeanExporter exporter, Injector injector, ObjectNameGenerator objectNameGenerator) {
        for (Mapping mapping : mappings) {
            exporter.export(mapping.getName(objectNameGenerator), injector.getInstance(mapping.getKey()));
        }
    }
}

