/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.prestosql.metadata.AggregationFunctionMetadata;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LiteralFunction;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.metadata.SpecializedFunctionKey;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.aggregation.ApproximateCountDistinctAggregation;
import io.prestosql.operator.aggregation.ApproximateDoublePercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateDoublePercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateLongPercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateLongPercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateRealPercentileAggregations;
import io.prestosql.operator.aggregation.ApproximateRealPercentileArrayAggregations;
import io.prestosql.operator.aggregation.ApproximateSetAggregation;
import io.prestosql.operator.aggregation.ArbitraryAggregationFunction;
import io.prestosql.operator.aggregation.AverageAggregations;
import io.prestosql.operator.aggregation.BitwiseAndAggregation;
import io.prestosql.operator.aggregation.BitwiseOrAggregation;
import io.prestosql.operator.aggregation.BooleanAndAggregation;
import io.prestosql.operator.aggregation.BooleanOrAggregation;
import io.prestosql.operator.aggregation.CentralMomentsAggregation;
import io.prestosql.operator.aggregation.ChecksumAggregationFunction;
import io.prestosql.operator.aggregation.CountAggregation;
import io.prestosql.operator.aggregation.CountColumn;
import io.prestosql.operator.aggregation.CountIfAggregation;
import io.prestosql.operator.aggregation.DecimalAverageAggregation;
import io.prestosql.operator.aggregation.DecimalSumAggregation;
import io.prestosql.operator.aggregation.DefaultApproximateCountDistinctAggregation;
import io.prestosql.operator.aggregation.DoubleCorrelationAggregation;
import io.prestosql.operator.aggregation.DoubleCovarianceAggregation;
import io.prestosql.operator.aggregation.DoubleHistogramAggregation;
import io.prestosql.operator.aggregation.DoubleRegressionAggregation;
import io.prestosql.operator.aggregation.DoubleSumAggregation;
import io.prestosql.operator.aggregation.GeometricMeanAggregations;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.IntervalDayToSecondAverageAggregation;
import io.prestosql.operator.aggregation.IntervalDayToSecondSumAggregation;
import io.prestosql.operator.aggregation.IntervalYearToMonthAverageAggregation;
import io.prestosql.operator.aggregation.IntervalYearToMonthSumAggregation;
import io.prestosql.operator.aggregation.LongSumAggregation;
import io.prestosql.operator.aggregation.MapAggregationFunction;
import io.prestosql.operator.aggregation.MapUnionAggregation;
import io.prestosql.operator.aggregation.MaxAggregationFunction;
import io.prestosql.operator.aggregation.MaxDataSizeForStats;
import io.prestosql.operator.aggregation.MaxNAggregationFunction;
import io.prestosql.operator.aggregation.MergeHyperLogLogAggregation;
import io.prestosql.operator.aggregation.MergeQuantileDigestFunction;
import io.prestosql.operator.aggregation.MinAggregationFunction;
import io.prestosql.operator.aggregation.MinNAggregationFunction;
import io.prestosql.operator.aggregation.QuantileDigestAggregationFunction;
import io.prestosql.operator.aggregation.RealAverageAggregation;
import io.prestosql.operator.aggregation.RealCorrelationAggregation;
import io.prestosql.operator.aggregation.RealCovarianceAggregation;
import io.prestosql.operator.aggregation.RealGeometricMeanAggregations;
import io.prestosql.operator.aggregation.RealHistogramAggregation;
import io.prestosql.operator.aggregation.RealRegressionAggregation;
import io.prestosql.operator.aggregation.RealSumAggregation;
import io.prestosql.operator.aggregation.ReduceAggregationFunction;
import io.prestosql.operator.aggregation.SumDataSizeForStats;
import io.prestosql.operator.aggregation.VarianceAggregation;
import io.prestosql.operator.aggregation.arrayagg.ArrayAggregationFunction;
import io.prestosql.operator.aggregation.histogram.Histogram;
import io.prestosql.operator.aggregation.minmaxby.MaxByAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MaxByNAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MinByAggregationFunction;
import io.prestosql.operator.aggregation.minmaxby.MinByNAggregationFunction;
import io.prestosql.operator.aggregation.multimapagg.MultimapAggregationFunction;
import io.prestosql.operator.scalar.ArrayAllMatchFunction;
import io.prestosql.operator.scalar.ArrayAnyMatchFunction;
import io.prestosql.operator.scalar.ArrayCardinalityFunction;
import io.prestosql.operator.scalar.ArrayCombinationsFunction;
import io.prestosql.operator.scalar.ArrayConcatFunction;
import io.prestosql.operator.scalar.ArrayConstructor;
import io.prestosql.operator.scalar.ArrayContains;
import io.prestosql.operator.scalar.ArrayDistinctFromOperator;
import io.prestosql.operator.scalar.ArrayDistinctFunction;
import io.prestosql.operator.scalar.ArrayElementAtFunction;
import io.prestosql.operator.scalar.ArrayEqualOperator;
import io.prestosql.operator.scalar.ArrayExceptFunction;
import io.prestosql.operator.scalar.ArrayFilterFunction;
import io.prestosql.operator.scalar.ArrayFlattenFunction;
import io.prestosql.operator.scalar.ArrayFunctions;
import io.prestosql.operator.scalar.ArrayGreaterThanOperator;
import io.prestosql.operator.scalar.ArrayGreaterThanOrEqualOperator;
import io.prestosql.operator.scalar.ArrayHashCodeOperator;
import io.prestosql.operator.scalar.ArrayIndeterminateOperator;
import io.prestosql.operator.scalar.ArrayIntersectFunction;
import io.prestosql.operator.scalar.ArrayJoin;
import io.prestosql.operator.scalar.ArrayLessThanOperator;
import io.prestosql.operator.scalar.ArrayLessThanOrEqualOperator;
import io.prestosql.operator.scalar.ArrayMaxFunction;
import io.prestosql.operator.scalar.ArrayMinFunction;
import io.prestosql.operator.scalar.ArrayNgramsFunction;
import io.prestosql.operator.scalar.ArrayNoneMatchFunction;
import io.prestosql.operator.scalar.ArrayNotEqualOperator;
import io.prestosql.operator.scalar.ArrayPositionFunction;
import io.prestosql.operator.scalar.ArrayReduceFunction;
import io.prestosql.operator.scalar.ArrayRemoveFunction;
import io.prestosql.operator.scalar.ArrayReverseFunction;
import io.prestosql.operator.scalar.ArrayShuffleFunction;
import io.prestosql.operator.scalar.ArraySliceFunction;
import io.prestosql.operator.scalar.ArraySortComparatorFunction;
import io.prestosql.operator.scalar.ArraySortFunction;
import io.prestosql.operator.scalar.ArraySubscriptOperator;
import io.prestosql.operator.scalar.ArrayToArrayCast;
import io.prestosql.operator.scalar.ArrayToElementConcatFunction;
import io.prestosql.operator.scalar.ArrayToJsonCast;
import io.prestosql.operator.scalar.ArrayTransformFunction;
import io.prestosql.operator.scalar.ArrayUnionFunction;
import io.prestosql.operator.scalar.ArraysOverlapFunction;
import io.prestosql.operator.scalar.BitwiseFunctions;
import io.prestosql.operator.scalar.CastFromUnknownOperator;
import io.prestosql.operator.scalar.CharacterStringCasts;
import io.prestosql.operator.scalar.ColorFunctions;
import io.prestosql.operator.scalar.CombineHashFunction;
import io.prestosql.operator.scalar.ConcatFunction;
import io.prestosql.operator.scalar.DataSizeFunctions;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.operator.scalar.ElementToArrayConcatFunction;
import io.prestosql.operator.scalar.EmptyMapConstructor;
import io.prestosql.operator.scalar.FailureFunction;
import io.prestosql.operator.scalar.FormatFunction;
import io.prestosql.operator.scalar.Greatest;
import io.prestosql.operator.scalar.HmacFunctions;
import io.prestosql.operator.scalar.HyperLogLogFunctions;
import io.prestosql.operator.scalar.IdentityCast;
import io.prestosql.operator.scalar.JoniRegexpCasts;
import io.prestosql.operator.scalar.JoniRegexpFunctions;
import io.prestosql.operator.scalar.JoniRegexpReplaceLambdaFunction;
import io.prestosql.operator.scalar.JsonFunctions;
import io.prestosql.operator.scalar.JsonOperators;
import io.prestosql.operator.scalar.JsonStringToArrayCast;
import io.prestosql.operator.scalar.JsonStringToMapCast;
import io.prestosql.operator.scalar.JsonStringToRowCast;
import io.prestosql.operator.scalar.JsonToArrayCast;
import io.prestosql.operator.scalar.JsonToMapCast;
import io.prestosql.operator.scalar.JsonToRowCast;
import io.prestosql.operator.scalar.Least;
import io.prestosql.operator.scalar.MapCardinalityFunction;
import io.prestosql.operator.scalar.MapConcatFunction;
import io.prestosql.operator.scalar.MapConstructor;
import io.prestosql.operator.scalar.MapDistinctFromOperator;
import io.prestosql.operator.scalar.MapElementAtFunction;
import io.prestosql.operator.scalar.MapEntriesFunction;
import io.prestosql.operator.scalar.MapEqualOperator;
import io.prestosql.operator.scalar.MapFilterFunction;
import io.prestosql.operator.scalar.MapFromEntriesFunction;
import io.prestosql.operator.scalar.MapHashCodeOperator;
import io.prestosql.operator.scalar.MapIndeterminateOperator;
import io.prestosql.operator.scalar.MapKeys;
import io.prestosql.operator.scalar.MapNotEqualOperator;
import io.prestosql.operator.scalar.MapSubscriptOperator;
import io.prestosql.operator.scalar.MapToJsonCast;
import io.prestosql.operator.scalar.MapToMapCast;
import io.prestosql.operator.scalar.MapTransformKeysFunction;
import io.prestosql.operator.scalar.MapTransformValuesFunction;
import io.prestosql.operator.scalar.MapValues;
import io.prestosql.operator.scalar.MapZipWithFunction;
import io.prestosql.operator.scalar.MathFunctions;
import io.prestosql.operator.scalar.MultimapFromEntriesFunction;
import io.prestosql.operator.scalar.QuantileDigestFunctions;
import io.prestosql.operator.scalar.Re2JCastToRegexpFunction;
import io.prestosql.operator.scalar.Re2JRegexpFunctions;
import io.prestosql.operator.scalar.Re2JRegexpReplaceLambdaFunction;
import io.prestosql.operator.scalar.RepeatFunction;
import io.prestosql.operator.scalar.RowDistinctFromOperator;
import io.prestosql.operator.scalar.RowEqualOperator;
import io.prestosql.operator.scalar.RowGreaterThanOperator;
import io.prestosql.operator.scalar.RowGreaterThanOrEqualOperator;
import io.prestosql.operator.scalar.RowHashCodeOperator;
import io.prestosql.operator.scalar.RowIndeterminateOperator;
import io.prestosql.operator.scalar.RowLessThanOperator;
import io.prestosql.operator.scalar.RowLessThanOrEqualOperator;
import io.prestosql.operator.scalar.RowNotEqualOperator;
import io.prestosql.operator.scalar.RowToJsonCast;
import io.prestosql.operator.scalar.RowToRowCast;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.operator.scalar.SequenceFunction;
import io.prestosql.operator.scalar.SessionFunctions;
import io.prestosql.operator.scalar.SplitToMapFunction;
import io.prestosql.operator.scalar.SplitToMultimapFunction;
import io.prestosql.operator.scalar.StringFunctions;
import io.prestosql.operator.scalar.TryCastFunction;
import io.prestosql.operator.scalar.TryFunction;
import io.prestosql.operator.scalar.TypeOfFunction;
import io.prestosql.operator.scalar.UrlFunctions;
import io.prestosql.operator.scalar.VarbinaryFunctions;
import io.prestosql.operator.scalar.WilsonInterval;
import io.prestosql.operator.scalar.WordStemFunction;
import io.prestosql.operator.scalar.ZipFunction;
import io.prestosql.operator.scalar.ZipWithFunction;
import io.prestosql.operator.window.AggregateWindowFunction;
import io.prestosql.operator.window.CumulativeDistributionFunction;
import io.prestosql.operator.window.DenseRankFunction;
import io.prestosql.operator.window.FirstValueFunction;
import io.prestosql.operator.window.LagFunction;
import io.prestosql.operator.window.LastValueFunction;
import io.prestosql.operator.window.LeadFunction;
import io.prestosql.operator.window.NTileFunction;
import io.prestosql.operator.window.NthValueFunction;
import io.prestosql.operator.window.PercentRankFunction;
import io.prestosql.operator.window.RankFunction;
import io.prestosql.operator.window.RowNumberFunction;
import io.prestosql.operator.window.SqlWindowFunction;
import io.prestosql.operator.window.WindowFunctionSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.BigintOperators;
import io.prestosql.type.BooleanOperators;
import io.prestosql.type.CharOperators;
import io.prestosql.type.ColorOperators;
import io.prestosql.type.DateOperators;
import io.prestosql.type.DateTimeOperators;
import io.prestosql.type.DecimalCasts;
import io.prestosql.type.DecimalInequalityOperators;
import io.prestosql.type.DecimalOperators;
import io.prestosql.type.DecimalSaturatedFloorCasts;
import io.prestosql.type.DecimalToDecimalCasts;
import io.prestosql.type.DoubleOperators;
import io.prestosql.type.HyperLogLogOperators;
import io.prestosql.type.IntegerOperators;
import io.prestosql.type.IntervalDayTimeOperators;
import io.prestosql.type.IntervalYearMonthOperators;
import io.prestosql.type.IpAddressOperators;
import io.prestosql.type.LikeFunctions;
import io.prestosql.type.QuantileDigestOperators;
import io.prestosql.type.RealOperators;
import io.prestosql.type.SmallintOperators;
import io.prestosql.type.TimeOperators;
import io.prestosql.type.TimeWithTimeZoneOperators;
import io.prestosql.type.TimestampOperators;
import io.prestosql.type.TimestampWithTimeZoneOperators;
import io.prestosql.type.TinyintOperators;
import io.prestosql.type.UnknownOperators;
import io.prestosql.type.UuidOperators;
import io.prestosql.type.VarbinaryOperators;
import io.prestosql.type.VarcharOperators;
import io.prestosql.type.setdigest.BuildSetDigestAggregation;
import io.prestosql.type.setdigest.MergeSetDigestAggregation;
import io.prestosql.type.setdigest.SetDigestFunctions;
import io.prestosql.type.setdigest.SetDigestOperators;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionRegistry {
    private final Cache<SpecializedFunctionKey, ScalarFunctionImplementation> specializedScalarCache;
    private final Cache<SpecializedFunctionKey, InternalAggregationFunction> specializedAggregationCache;
    private final Cache<SpecializedFunctionKey, WindowFunctionSupplier> specializedWindowCache;
    private volatile FunctionMap functions = new FunctionMap();

    public FunctionRegistry(Metadata metadata, FeaturesConfig featuresConfig) {
        this.specializedScalarCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        this.specializedAggregationCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        this.specializedWindowCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        FunctionListBuilder builder = new FunctionListBuilder().window(RowNumberFunction.class).window(RankFunction.class).window(DenseRankFunction.class).window(PercentRankFunction.class).window(CumulativeDistributionFunction.class).window(NTileFunction.class).window(FirstValueFunction.class).window(LastValueFunction.class).window(NthValueFunction.class).window(LagFunction.class).window(LeadFunction.class).aggregate(ApproximateCountDistinctAggregation.class).aggregate(DefaultApproximateCountDistinctAggregation.class).aggregate(SumDataSizeForStats.class).aggregate(MaxDataSizeForStats.class).aggregates(CountAggregation.class).aggregates(VarianceAggregation.class).aggregates(CentralMomentsAggregation.class).aggregates(ApproximateLongPercentileAggregations.class).aggregates(ApproximateLongPercentileArrayAggregations.class).aggregates(ApproximateDoublePercentileAggregations.class).aggregates(ApproximateDoublePercentileArrayAggregations.class).aggregates(ApproximateRealPercentileAggregations.class).aggregates(ApproximateRealPercentileArrayAggregations.class).aggregates(CountIfAggregation.class).aggregates(BooleanAndAggregation.class).aggregates(BooleanOrAggregation.class).aggregates(DoubleSumAggregation.class).aggregates(RealSumAggregation.class).aggregates(LongSumAggregation.class).aggregates(IntervalDayToSecondSumAggregation.class).aggregates(IntervalYearToMonthSumAggregation.class).aggregates(AverageAggregations.class).function(RealAverageAggregation.REAL_AVERAGE_AGGREGATION).aggregates(IntervalDayToSecondAverageAggregation.class).aggregates(IntervalYearToMonthAverageAggregation.class).aggregates(GeometricMeanAggregations.class).aggregates(RealGeometricMeanAggregations.class).aggregates(MergeHyperLogLogAggregation.class).aggregates(ApproximateSetAggregation.class).functions(QuantileDigestAggregationFunction.QDIGEST_AGG, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT, QuantileDigestAggregationFunction.QDIGEST_AGG_WITH_WEIGHT_AND_ERROR).function(MergeQuantileDigestFunction.MERGE).aggregates(DoubleHistogramAggregation.class).aggregates(RealHistogramAggregation.class).aggregates(DoubleCovarianceAggregation.class).aggregates(RealCovarianceAggregation.class).aggregates(DoubleRegressionAggregation.class).aggregates(RealRegressionAggregation.class).aggregates(DoubleCorrelationAggregation.class).aggregates(RealCorrelationAggregation.class).aggregates(BitwiseOrAggregation.class).aggregates(BitwiseAndAggregation.class).scalar(RepeatFunction.class).scalars(SequenceFunction.class).scalars(SessionFunctions.class).scalars(StringFunctions.class).scalars(WordStemFunction.class).scalar(SplitToMapFunction.class).scalar(SplitToMultimapFunction.class).scalars(VarbinaryFunctions.class).scalars(UrlFunctions.class).scalars(MathFunctions.class).scalar(MathFunctions.Abs.class).scalar(MathFunctions.Sign.class).scalar(MathFunctions.Round.class).scalar(MathFunctions.RoundN.class).scalar(MathFunctions.Truncate.class).scalar(MathFunctions.TruncateN.class).scalar(MathFunctions.Ceiling.class).scalar(MathFunctions.Floor.class).scalars(BitwiseFunctions.class).scalars(DateTimeFunctions.class).scalars(JsonFunctions.class).scalars(ColorFunctions.class).scalars(ColorOperators.class).scalar(ColorOperators.ColorDistinctFromOperator.class).scalars(HyperLogLogFunctions.class).scalars(QuantileDigestFunctions.class).scalars(UnknownOperators.class).scalar(UnknownOperators.UnknownDistinctFromOperator.class).scalars(BooleanOperators.class).scalar(BooleanOperators.BooleanDistinctFromOperator.class).scalars(BigintOperators.class).scalar(BigintOperators.BigintDistinctFromOperator.class).scalars(IntegerOperators.class).scalar(IntegerOperators.IntegerDistinctFromOperator.class).scalars(SmallintOperators.class).scalar(SmallintOperators.SmallintDistinctFromOperator.class).scalars(TinyintOperators.class).scalar(TinyintOperators.TinyintDistinctFromOperator.class).scalars(DoubleOperators.class).scalar(DoubleOperators.DoubleDistinctFromOperator.class).scalars(RealOperators.class).scalar(RealOperators.RealDistinctFromOperator.class).scalars(VarcharOperators.class).scalar(VarcharOperators.VarcharDistinctFromOperator.class).scalars(VarbinaryOperators.class).scalar(VarbinaryOperators.VarbinaryDistinctFromOperator.class).scalars(DateOperators.class).scalar(DateOperators.DateDistinctFromOperator.class).scalars(TimeOperators.class).scalar(TimeOperators.TimeDistinctFromOperator.class).scalars(TimestampOperators.class).scalar(TimestampOperators.TimestampDistinctFromOperator.class).scalars(IntervalDayTimeOperators.class).scalar(IntervalDayTimeOperators.IntervalDayTimeDistinctFromOperator.class).scalars(IntervalYearMonthOperators.class).scalar(IntervalYearMonthOperators.IntervalYearMonthDistinctFromOperator.class).scalars(TimeWithTimeZoneOperators.class).scalar(TimeWithTimeZoneOperators.TimeWithTimeZoneDistinctFromOperator.class).scalars(TimestampWithTimeZoneOperators.class).scalar(TimestampWithTimeZoneOperators.TimestampWithTimeZoneDistinctFromOperator.class).scalars(DateTimeOperators.class).scalars(HyperLogLogOperators.class).scalars(QuantileDigestOperators.class).scalars(IpAddressOperators.class).scalar(IpAddressOperators.IpAddressDistinctFromOperator.class).scalars(UuidOperators.class).scalar(UuidOperators.UuidDistinctFromOperator.class).scalars(LikeFunctions.class).scalars(ArrayFunctions.class).scalars(HmacFunctions.class).scalars(DataSizeFunctions.class).scalar(ArrayCardinalityFunction.class).scalar(ArrayContains.class).scalar(ArrayFilterFunction.class).scalar(ArrayPositionFunction.class).scalars(CombineHashFunction.class).scalars(JsonOperators.class).scalar(JsonOperators.JsonDistinctFromOperator.class).scalars(FailureFunction.class).scalars(JoniRegexpCasts.class).scalars(CharacterStringCasts.class).scalars(CharOperators.class).scalar(CharOperators.CharDistinctFromOperator.class).scalar(DecimalOperators.Negation.class).scalar(DecimalOperators.HashCode.class).scalar(DecimalOperators.Indeterminate.class).scalar(DecimalOperators.XxHash64Operator.class).functions(IdentityCast.IDENTITY_CAST, CastFromUnknownOperator.CAST_FROM_UNKNOWN).scalar(ArrayLessThanOperator.class).scalar(ArrayLessThanOrEqualOperator.class).scalar(ArrayRemoveFunction.class).scalar(ArrayGreaterThanOperator.class).scalar(ArrayGreaterThanOrEqualOperator.class).scalar(ArrayElementAtFunction.class).scalar(ArraySortFunction.class).scalar(ArraySortComparatorFunction.class).scalar(ArrayShuffleFunction.class).scalar(ArrayReverseFunction.class).scalar(ArrayMinFunction.class).scalar(ArrayMaxFunction.class).scalar(ArrayDistinctFunction.class).scalar(ArrayNotEqualOperator.class).scalar(ArrayEqualOperator.class).scalar(ArrayHashCodeOperator.class).scalar(ArrayIntersectFunction.class).scalar(ArraysOverlapFunction.class).scalar(ArrayDistinctFromOperator.class).scalar(ArrayUnionFunction.class).scalar(ArrayExceptFunction.class).scalar(ArraySliceFunction.class).scalar(ArrayIndeterminateOperator.class).scalar(ArrayCombinationsFunction.class).scalar(ArrayNgramsFunction.class).scalar(ArrayAllMatchFunction.class).scalar(ArrayAnyMatchFunction.class).scalar(ArrayNoneMatchFunction.class).scalar(MapDistinctFromOperator.class).scalar(MapEqualOperator.class).scalar(MapEntriesFunction.class).scalar(MapFromEntriesFunction.class).scalar(MultimapFromEntriesFunction.class).scalar(MapNotEqualOperator.class).scalar(MapKeys.class).scalar(MapValues.class).scalar(MapCardinalityFunction.class).scalar(EmptyMapConstructor.class).scalar(MapIndeterminateOperator.class).scalar(TypeOfFunction.class).scalar(TryFunction.class).scalar(DynamicFilters.Function.class).functions(ZipWithFunction.ZIP_WITH_FUNCTION, MapZipWithFunction.MAP_ZIP_WITH_FUNCTION).functions(ZipFunction.ZIP_FUNCTIONS).functions(ArrayJoin.ARRAY_JOIN, ArrayJoin.ARRAY_JOIN_WITH_NULL_REPLACEMENT).functions(ArrayToArrayCast.ARRAY_TO_ARRAY_CAST).functions(ArrayToElementConcatFunction.ARRAY_TO_ELEMENT_CONCAT_FUNCTION, ElementToArrayConcatFunction.ELEMENT_TO_ARRAY_CONCAT_FUNCTION).function(MapHashCodeOperator.MAP_HASH_CODE).function(MapElementAtFunction.MAP_ELEMENT_AT).function(MapConcatFunction.MAP_CONCAT_FUNCTION).function(MapToMapCast.MAP_TO_MAP_CAST).function(ArrayFlattenFunction.ARRAY_FLATTEN_FUNCTION).function(ArrayConcatFunction.ARRAY_CONCAT_FUNCTION).functions(ArrayConstructor.ARRAY_CONSTRUCTOR, ArraySubscriptOperator.ARRAY_SUBSCRIPT, ArrayToJsonCast.ARRAY_TO_JSON, JsonToArrayCast.JSON_TO_ARRAY, JsonStringToArrayCast.JSON_STRING_TO_ARRAY).function(new ArrayAggregationFunction(featuresConfig.getArrayAggGroupImplementation())).functions(new MapSubscriptOperator()).functions(MapConstructor.MAP_CONSTRUCTOR, MapToJsonCast.MAP_TO_JSON, JsonToMapCast.JSON_TO_MAP, JsonStringToMapCast.JSON_STRING_TO_MAP).functions(MapAggregationFunction.MAP_AGG, MapUnionAggregation.MAP_UNION).function(ReduceAggregationFunction.REDUCE_AGG).function(new MultimapAggregationFunction(featuresConfig.getMultimapAggGroupImplementation())).functions(DecimalCasts.DECIMAL_TO_VARCHAR_CAST, DecimalCasts.DECIMAL_TO_INTEGER_CAST, DecimalCasts.DECIMAL_TO_BIGINT_CAST, DecimalCasts.DECIMAL_TO_DOUBLE_CAST, DecimalCasts.DECIMAL_TO_REAL_CAST, DecimalCasts.DECIMAL_TO_BOOLEAN_CAST, DecimalCasts.DECIMAL_TO_TINYINT_CAST, DecimalCasts.DECIMAL_TO_SMALLINT_CAST).functions(DecimalCasts.VARCHAR_TO_DECIMAL_CAST, DecimalCasts.INTEGER_TO_DECIMAL_CAST, DecimalCasts.BIGINT_TO_DECIMAL_CAST, DecimalCasts.DOUBLE_TO_DECIMAL_CAST, DecimalCasts.REAL_TO_DECIMAL_CAST, DecimalCasts.BOOLEAN_TO_DECIMAL_CAST, DecimalCasts.TINYINT_TO_DECIMAL_CAST, DecimalCasts.SMALLINT_TO_DECIMAL_CAST).functions(DecimalCasts.JSON_TO_DECIMAL_CAST, DecimalCasts.DECIMAL_TO_JSON_CAST).functions(DecimalOperators.DECIMAL_ADD_OPERATOR, DecimalOperators.DECIMAL_SUBTRACT_OPERATOR, DecimalOperators.DECIMAL_MULTIPLY_OPERATOR, DecimalOperators.DECIMAL_DIVIDE_OPERATOR, DecimalOperators.DECIMAL_MODULUS_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_EQUAL_OPERATOR, DecimalInequalityOperators.DECIMAL_NOT_EQUAL_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_LESS_THAN_OPERATOR, DecimalInequalityOperators.DECIMAL_LESS_THAN_OR_EQUAL_OPERATOR).functions(DecimalInequalityOperators.DECIMAL_GREATER_THAN_OPERATOR, DecimalInequalityOperators.DECIMAL_GREATER_THAN_OR_EQUAL_OPERATOR).function(DecimalSaturatedFloorCasts.DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_BIGINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.BIGINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_INTEGER_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.INTEGER_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_SMALLINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.SMALLINT_TO_DECIMAL_SATURATED_FLOOR_CAST).functions(DecimalSaturatedFloorCasts.DECIMAL_TO_TINYINT_SATURATED_FLOOR_CAST, DecimalSaturatedFloorCasts.TINYINT_TO_DECIMAL_SATURATED_FLOOR_CAST).function(DecimalInequalityOperators.DECIMAL_BETWEEN_OPERATOR).function(DecimalInequalityOperators.DECIMAL_DISTINCT_FROM_OPERATOR).function(new Histogram(featuresConfig.getHistogramGroupImplementation())).function(ChecksumAggregationFunction.CHECKSUM_AGGREGATION).function(ArbitraryAggregationFunction.ARBITRARY_AGGREGATION).functions(Greatest.GREATEST, Least.LEAST).functions(MaxByAggregationFunction.MAX_BY, MinByAggregationFunction.MIN_BY, MaxByNAggregationFunction.MAX_BY_N_AGGREGATION, MinByNAggregationFunction.MIN_BY_N_AGGREGATION).functions(MaxAggregationFunction.MAX_AGGREGATION, MinAggregationFunction.MIN_AGGREGATION, MaxNAggregationFunction.MAX_N_AGGREGATION, MinNAggregationFunction.MIN_N_AGGREGATION).function(CountColumn.COUNT_COLUMN).functions(RowHashCodeOperator.ROW_HASH_CODE, RowToJsonCast.ROW_TO_JSON, JsonToRowCast.JSON_TO_ROW, JsonStringToRowCast.JSON_STRING_TO_ROW, RowDistinctFromOperator.ROW_DISTINCT_FROM, RowEqualOperator.ROW_EQUAL, RowGreaterThanOperator.ROW_GREATER_THAN, RowGreaterThanOrEqualOperator.ROW_GREATER_THAN_OR_EQUAL, RowLessThanOperator.ROW_LESS_THAN, RowLessThanOrEqualOperator.ROW_LESS_THAN_OR_EQUAL, RowNotEqualOperator.ROW_NOT_EQUAL, RowToRowCast.ROW_TO_ROW_CAST, RowIndeterminateOperator.ROW_INDETERMINATE).functions(ConcatFunction.VARCHAR_CONCAT, ConcatFunction.VARBINARY_CONCAT).function(DecimalToDecimalCasts.DECIMAL_TO_DECIMAL_CAST).function(Re2JCastToRegexpFunction.castVarcharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(Re2JCastToRegexpFunction.castCharToRe2JRegexp(featuresConfig.getRe2JDfaStatesLimit(), featuresConfig.getRe2JDfaRetries())).function(DecimalAverageAggregation.DECIMAL_AVERAGE_AGGREGATION).function(DecimalSumAggregation.DECIMAL_SUM_AGGREGATION).function(MathFunctions.DECIMAL_MOD_FUNCTION).functions(ArrayTransformFunction.ARRAY_TRANSFORM_FUNCTION, ArrayReduceFunction.ARRAY_REDUCE_FUNCTION).functions(MapFilterFunction.MAP_FILTER_FUNCTION, MapTransformKeysFunction.MAP_TRANSFORM_KEYS_FUNCTION, MapTransformValuesFunction.MAP_TRANSFORM_VALUES_FUNCTION).function(FormatFunction.FORMAT_FUNCTION).function(TryCastFunction.TRY_CAST).function(new LiteralFunction()).aggregate(MergeSetDigestAggregation.class).aggregate(BuildSetDigestAggregation.class).scalars(SetDigestFunctions.class).scalars(SetDigestOperators.class).scalars(WilsonInterval.class);
        switch (featuresConfig.getRegexLibrary()) {
            case JONI: {
                builder.scalars(JoniRegexpFunctions.class);
                builder.scalar(JoniRegexpReplaceLambdaFunction.class);
                break;
            }
            case RE2J: {
                builder.scalars(Re2JRegexpFunctions.class);
                builder.scalar(Re2JRegexpReplaceLambdaFunction.class);
            }
        }
        this.addFunctions(builder.getFunctions());
    }

    public final synchronized void addFunctions(List<? extends SqlFunction> functions) {
        for (SqlFunction sqlFunction : functions) {
            FunctionMetadata functionMetadata = sqlFunction.getFunctionMetadata();
            Preconditions.checkArgument((!functionMetadata.getSignature().getName().contains("|") ? 1 : 0) != 0, (String)"Function name cannot contain '|' character: %s", (Object)functionMetadata.getSignature());
            for (FunctionMetadata existingFunction : this.functions.list()) {
                Preconditions.checkArgument((!functionMetadata.getFunctionId().equals(existingFunction.getFunctionId()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getFunctionId());
                Preconditions.checkArgument((!functionMetadata.getSignature().equals(existingFunction.getSignature()) ? 1 : 0) != 0, (String)"Function already registered: %s", (Object)functionMetadata.getSignature());
            }
        }
        this.functions = new FunctionMap(this.functions, functions);
    }

    public List<FunctionMetadata> list() {
        return this.functions.list();
    }

    public Collection<FunctionMetadata> get(QualifiedName name) {
        return this.functions.get(name);
    }

    public FunctionMetadata get(FunctionId functionId) {
        return this.functions.get(functionId).getFunctionMetadata();
    }

    public AggregationFunctionMetadata getAggregationFunctionMetadata(Metadata metadata, ResolvedFunction resolvedFunction) {
        SqlFunction function = this.functions.get(resolvedFunction.getFunctionId());
        Preconditions.checkArgument((boolean)(function instanceof SqlAggregationFunction), (String)"%s is not an aggregation function", (Object)resolvedFunction);
        SqlAggregationFunction aggregationFunction = (SqlAggregationFunction)function;
        if (!aggregationFunction.isDecomposable()) {
            return new AggregationFunctionMetadata(aggregationFunction.isOrderSensitive(), Optional.empty());
        }
        InternalAggregationFunction implementation = this.getAggregateFunctionImplementation(metadata, resolvedFunction);
        return new AggregationFunctionMetadata(aggregationFunction.isOrderSensitive(), Optional.of(implementation.getIntermediateType().getTypeSignature()));
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(Metadata metadata, ResolvedFunction resolvedFunction) {
        SpecializedFunctionKey key = this.getSpecializedFunctionKey(metadata, resolvedFunction);
        try {
            if (key.getFunction() instanceof SqlAggregationFunction) {
                return AggregateWindowFunction.supplier(key.getFunction().getFunctionMetadata().getSignature(), (InternalAggregationFunction)this.specializedAggregationCache.get((Object)key, () -> FunctionRegistry.specializedAggregation(metadata, key)));
            }
            return (WindowFunctionSupplier)this.specializedWindowCache.get((Object)key, () -> FunctionRegistry.specializeWindow(metadata, key));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private static WindowFunctionSupplier specializeWindow(Metadata metadata, SpecializedFunctionKey key) {
        return ((SqlWindowFunction)key.getFunction()).specialize(key.getBoundVariables(), key.getArity(), metadata);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(Metadata metadata, ResolvedFunction resolvedFunction) {
        SpecializedFunctionKey key = this.getSpecializedFunctionKey(metadata, resolvedFunction);
        try {
            return (InternalAggregationFunction)this.specializedAggregationCache.get((Object)key, () -> FunctionRegistry.specializedAggregation(metadata, key));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private static InternalAggregationFunction specializedAggregation(Metadata metadata, SpecializedFunctionKey key) {
        SqlAggregationFunction function = (SqlAggregationFunction)key.getFunction();
        InternalAggregationFunction implementation = function.specialize(key.getBoundVariables(), key.getArity(), metadata);
        Preconditions.checkArgument((function.isOrderSensitive() == implementation.isOrderSensitive() ? 1 : 0) != 0, (String)"implementation order sensitivity doesn't match for: %s", (Object)function.getFunctionMetadata().getSignature());
        Preconditions.checkArgument((function.isDecomposable() == implementation.isDecomposable() ? 1 : 0) != 0, (String)"implementation decomposable doesn't match for: %s", (Object)function.getFunctionMetadata().getSignature());
        return implementation;
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(Metadata metadata, ResolvedFunction resolvedFunction) {
        SpecializedFunctionKey key = this.getSpecializedFunctionKey(metadata, resolvedFunction);
        try {
            return (ScalarFunctionImplementation)this.specializedScalarCache.get((Object)key, () -> FunctionRegistry.specializeScalarFunction(metadata, key));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private static ScalarFunctionImplementation specializeScalarFunction(Metadata metadata, SpecializedFunctionKey key) {
        SqlScalarFunction function = (SqlScalarFunction)key.getFunction();
        ScalarFunctionImplementation specialize = function.specialize(key.getBoundVariables(), key.getArity(), metadata);
        FunctionMetadata functionMetadata = function.getFunctionMetadata();
        for (ScalarFunctionImplementation.ScalarImplementationChoice choice : specialize.getAllChoices()) {
            Preconditions.checkArgument((choice.isNullable() == functionMetadata.isNullable() ? 1 : 0) != 0, (Object)("choice nullability doesn't match for: " + functionMetadata.getSignature()));
            for (int i = 0; i < choice.getArgumentProperties().size(); ++i) {
                ScalarFunctionImplementation.ArgumentProperty argumentProperty = choice.getArgumentProperty(i);
                int functionArgumentIndex = functionMetadata.getSignature().isVariableArity() ? Math.min(i, functionMetadata.getSignature().getArgumentTypes().size() - 1) : i;
                boolean functionPropertyNullability = functionMetadata.getArgumentDefinitions().get(functionArgumentIndex).isNullable();
                if (argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.FUNCTION_TYPE) {
                    Preconditions.checkArgument((!functionPropertyNullability ? 1 : 0) != 0, (Object)("choice function argument must not be nullable: " + functionMetadata.getSignature()));
                    continue;
                }
                if (argumentProperty.getNullConvention() == ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION) continue;
                boolean choiceNullability = argumentProperty.getNullConvention() != ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL;
                Preconditions.checkArgument((functionPropertyNullability == choiceNullability ? 1 : 0) != 0, (Object)("choice function argument nullability doesn't match for: " + functionMetadata.getSignature()));
            }
        }
        return specialize;
    }

    private SpecializedFunctionKey getSpecializedFunctionKey(Metadata metadata, ResolvedFunction resolvedFunction) {
        SqlFunction function = this.functions.get(resolvedFunction.getFunctionId());
        Signature signature = resolvedFunction.getSignature();
        BoundVariables boundVariables = new SignatureBinder(metadata, function.getFunctionMetadata().getSignature(), false).bindVariables(TypeSignatureProvider.fromTypeSignatures(signature.getArgumentTypes()), signature.getReturnType()).orElseThrow(() -> new IllegalArgumentException("Could not extract bound variables"));
        return new SpecializedFunctionKey(function, boundVariables, signature.getArgumentTypes().size());
    }

    private static class FunctionMap {
        private final Map<FunctionId, SqlFunction> functions;
        private final Multimap<QualifiedName, FunctionMetadata> functionsByName;

        public FunctionMap() {
            this.functions = ImmutableMap.of();
            this.functionsByName = ImmutableListMultimap.of();
        }

        public FunctionMap(FunctionMap map, Collection<? extends SqlFunction> functions) {
            this.functions = ImmutableMap.builder().putAll(map.functions).putAll((Map)Maps.uniqueIndex(functions, function -> function.getFunctionMetadata().getFunctionId())).build();
            ImmutableListMultimap.Builder functionsByName = ImmutableListMultimap.builder().putAll(map.functionsByName);
            functions.stream().map(SqlFunction::getFunctionMetadata).forEach(functionMetadata -> functionsByName.put((Object)QualifiedName.of((String)functionMetadata.getSignature().getName()), functionMetadata));
            this.functionsByName = functionsByName.build();
            for (Map.Entry entry : this.functionsByName.asMap().entrySet()) {
                Collection values = (Collection)entry.getValue();
                long aggregations = values.stream().map(FunctionMetadata::getKind).filter(kind -> kind == FunctionKind.AGGREGATE).count();
                Preconditions.checkState((aggregations == 0L || aggregations == (long)values.size() ? 1 : 0) != 0, (String)"'%s' is both an aggregation and a scalar function", entry.getKey());
            }
        }

        public List<FunctionMetadata> list() {
            return ImmutableList.copyOf((Collection)this.functionsByName.values());
        }

        public Collection<FunctionMetadata> get(QualifiedName name) {
            return this.functionsByName.get((Object)name);
        }

        public SqlFunction get(FunctionId functionId) {
            SqlFunction sqlFunction = this.functions.get(functionId);
            Preconditions.checkArgument((sqlFunction != null ? 1 : 0) != 0, (Object)("Unknown function implementation: " + functionId));
            return sqlFunction;
        }
    }
}

