/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import java.util.Map;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonDurableCursorImpl
extends ManagedCursorImpl {
    private static final Logger log = LoggerFactory.getLogger(NonDurableCursorImpl.class);

    NonDurableCursorImpl(BookKeeper bookkeeper, ManagedLedgerConfig config, ManagedLedgerImpl ledger, String cursorName, PositionImpl startCursorPosition, CommandSubscribe.InitialPosition initialPosition) {
        super(bookkeeper, config, ledger, cursorName);
        if (startCursorPosition == null || startCursorPosition.compareTo(ledger.lastConfirmedEntry) > 0) {
            switch (initialPosition) {
                case Latest: {
                    this.initializeCursorPosition(ledger.getLastPositionAndCounter());
                    break;
                }
                case Earliest: {
                    this.initializeCursorPosition(ledger.getFirstPositionAndCounter());
                }
            }
        } else if (startCursorPosition.getLedgerId() == PositionImpl.earliest.getLedgerId()) {
            this.recoverCursor(ledger.getPreviousPosition(ledger.getFirstPosition()));
        } else {
            this.recoverCursor(startCursorPosition);
        }
        log.info("[{}] Created non-durable cursor read-position={} mark-delete-position={}", new Object[]{ledger.getName(), this.readPosition, this.markDeletePosition});
    }

    private void recoverCursor(PositionImpl mdPosition) {
        Pair<PositionImpl, Long> lastEntryAndCounter = this.ledger.getLastPositionAndCounter();
        this.readPosition = this.ledger.getNextValidPosition(mdPosition);
        this.markDeletePosition = mdPosition;
        if (null != this.readPosition) {
            long initialBacklog = this.readPosition.compareTo((PositionImpl)lastEntryAndCounter.getLeft()) < 0 ? this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.closed((Comparable)this.readPosition, (Comparable)((Comparable)lastEntryAndCounter.getLeft()))) : 0L;
            this.messagesConsumedCounter = (Long)lastEntryAndCounter.getRight() - initialBacklog;
        } else {
            log.warn("Recovered a non-durable cursor from position {} but didn't find a valid read position {}", (Object)mdPosition, (Object)this.readPosition);
        }
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    void recover(ManagedCursorImpl.VoidCallback callback) {
    }

    @Override
    protected void internalAsyncMarkDelete(PositionImpl newPosition, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        ManagedCursorImpl.MarkDeleteEntry mdEntry;
        this.lastMarkDeleteEntry = mdEntry = new ManagedCursorImpl.MarkDeleteEntry(newPosition, properties, callback, ctx);
        this.ledger.updateCursor(this, mdEntry.newPosition);
        callback.markDeleteComplete(ctx);
    }

    @Override
    public void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        callback.closeComplete(ctx);
    }

    public void asyncDeleteCursor(String consumerName, AsyncCallbacks.DeleteCursorCallback callback, Object ctx) {
        callback.deleteCursorComplete(ctx);
    }

    @Override
    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ledger", (Object)this.ledger.getName()).add("ackPos", (Object)this.markDeletePosition).add("readPos", (Object)this.readPosition).toString();
    }
}

